/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * MakroAction.cpp
 *
 *  Created on: Dec 17, 2009
 *      Author: crueger
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include <string>

#include "Actions/MakroAction.hpp"
#include "Actions/Action.hpp"
#include "Actions/ActionSequence.hpp"
#include "Helpers/Assert.hpp"

using namespace std;

class MakroActionState : public ActionState{
public:
  MakroActionState(ActionSequence::stateSet _states) :
    states(_states)
  {}
  virtual ~MakroActionState(){
    // All contained states are destroyed by the shared ptrs
  }

  ActionSequence::stateSet states;
};

MakroAction::MakroAction(string _name,ActionSequence* _actions,bool _doRegister) :
Action(_name,_doRegister),
actions(_actions)
{
}

MakroAction::~MakroAction()
{
  Action* action;
  while((action=actions->removeLastAction())){
    delete action;
  }
  delete actions;
}

void MakroAction::getParametersfromValueStorage()
{};

Dialog* MakroAction::fillDialog(Dialog *dialog) {
  return actions->fillAllDialogs(dialog);
}

Action::state_ptr MakroAction::performCall(){
  ActionSequence::stateSet states = actions->callAll(true);
  return Action::state_ptr(new MakroActionState(states));
}

Action::state_ptr MakroAction::performUndo(Action::state_ptr _state) {
  MakroActionState *state = dynamic_cast<MakroActionState*>(_state.get());
  ASSERT(state,"Type mismatch for the state of the MakroAction");
  ActionSequence::stateSet states = actions->undoAll(state->states);
  return Action::state_ptr(new MakroActionState(states));
}

Action::state_ptr MakroAction::performRedo(Action::state_ptr _state){
  MakroActionState *state = dynamic_cast<MakroActionState*>(_state.get());
  ASSERT(state,"Type mismatch for the state of the MakroAction");
  ActionSequence::stateSet states = actions->redoAll(state->states);
  return Action::state_ptr(new MakroActionState(states));
}

bool MakroAction::canUndo() {
  return actions->canUndo();
}

bool MakroAction::shouldUndo() {
  return actions->shouldUndo();
}
