/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * DepthFirstSearchAction.cpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "atom.hpp"
#include "bondgraph.hpp"
#include "config.hpp"
#include "Helpers/Log.hpp"
#include "molecule.hpp"
#include "Descriptors/MoleculeDescriptor.hpp"
#include "Descriptors/MoleculeIdDescriptor.hpp"
#include "stackclass.hpp"
#include "Helpers/Verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "Actions/FragmentationAction/DepthFirstSearchAction.hpp"

// and construct the stuff
#include "DepthFirstSearchAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr FragmentationDepthFirstSearchAction::performCall() {
  // obtain information
  getParametersfromValueStorage();

  DoLog(1) && (Log() << Verbose(1) << "Depth-First-Search Analysis." << endl);
  molecule * const mol = World::getInstance().getMolecule(MoleculeById(0));
  MoleculeLeafClass *Subgraphs = NULL;      // list of subgraphs from DFS analysis
  int *MinimumRingSize = new int[mol->getAtomCount()];
  atom **ListOfAtoms = NULL;
  class StackClass<bond *> *BackEdgeStack = NULL;
  class StackClass<bond *> *LocalBackEdgeStack = NULL;
  mol->CreateAdjacencyList(params.distance, World::getInstance().getConfig()->GetIsAngstroem(), &BondGraph::CovalentMinMaxDistance, NULL);
  Subgraphs = mol->DepthFirstSearchAnalysis(BackEdgeStack);
  if (Subgraphs != NULL) {
    int FragmentCounter = 0;
    while (Subgraphs->next != NULL) {
      Subgraphs = Subgraphs->next;
      ListOfAtoms = NULL;
      Subgraphs->FillBondStructureFromReference(mol, ListOfAtoms, false);  // we want to keep the created ListOfLocalAtoms
      LocalBackEdgeStack = new StackClass<bond *> (Subgraphs->Leaf->BondCount);
      Subgraphs->Leaf->PickLocalBackEdges(ListOfAtoms, BackEdgeStack, LocalBackEdgeStack);
      Subgraphs->Leaf->CyclicStructureAnalysis(LocalBackEdgeStack, MinimumRingSize);
      delete(LocalBackEdgeStack);
      delete(Subgraphs->previous);
      delete[](ListOfAtoms);  // and here we remove it
      FragmentCounter++;
    }
    delete(Subgraphs);
  }
  delete(BackEdgeStack);
  delete[](MinimumRingSize);
  return Action::success;
}

Action::state_ptr FragmentationDepthFirstSearchAction::performUndo(Action::state_ptr _state) {
  return Action::success;
}

Action::state_ptr FragmentationDepthFirstSearchAction::performRedo(Action::state_ptr _state){
  return Action::success;
}

bool FragmentationDepthFirstSearchAction::canUndo() {
  return true;
}

bool FragmentationDepthFirstSearchAction::shouldUndo() {
  return true;
}

const string FragmentationDepthFirstSearchAction::getName() {
  return NAME;
}
/** =========== end of function ====================== */
