/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * ErrorAction.cpp
 *
 *  Created on: Jan 5, 2010
 *      Author: crueger
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include <iostream>

#include "Actions/ErrorAction.hpp"
#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"
#include "Helpers/Assert.hpp"

using namespace std;

ErrorAction::ErrorAction(string _name,const char * _errorMsg,bool _doRegister) :
Action(_name,_doRegister),
errorMsg(_errorMsg)
{
}

ErrorAction::~ErrorAction()
{
}

Dialog* ErrorAction::createDialog() {
  return NULL;
}

void ErrorAction::getParametersfromValueStorage()
{}

Action::state_ptr ErrorAction::performCall() {
  Log() << Verbose(0) << errorMsg << endl;
  return Action::success;
}
Action::state_ptr ErrorAction::performUndo(Action::state_ptr) {
  ASSERT(0,"Undo called for an ErrorAction");
  return Action::success;
}

Action::state_ptr ErrorAction::performRedo(Action::state_ptr) {
  ASSERT(0,"Redo called for an ErrorAction");
  return Action::success;
}

bool ErrorAction::canUndo(){
  return false;
}

bool ErrorAction::shouldUndo(){
  return false;
}
