/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * VerboseAction.cpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "Actions/CommandAction/VerboseAction.hpp"

// and construct the stuff
#include "VerboseAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr CommandVerboseAction::performCall() {
  int oldverbosity = getVerbosity();

  // obtain information
  getParametersfromValueStorage();

  if (oldverbosity != params.verbosity) {
    CommandVerboseState *UndoState = new CommandVerboseState(oldverbosity, params);
    setVerbosity(params.verbosity);
    DoLog(0) && (Log() << Verbose(0) << "Setting verbosity from " << oldverbosity << " to " << params.verbosity << "." << endl);
    return Action::state_ptr(UndoState);
  } else {
    DoLog(0) && (Log() << Verbose(0) << "Verbosity remains unchanged at " << oldverbosity << "." << endl);
    return Action::failure;
  }
}

Action::state_ptr CommandVerboseAction::performUndo(Action::state_ptr _state) {
  CommandVerboseState *state = assert_cast<CommandVerboseState*>(_state.get());

  DoLog(0) && (Log() << Verbose(0) << "Setting verbosity from " << state->params.verbosity << " to " << state->oldverbosity << "." << endl);
  setVerbosity(state->oldverbosity);

  return Action::state_ptr(_state);
}

Action::state_ptr CommandVerboseAction::performRedo(Action::state_ptr _state){
  CommandVerboseState *state = assert_cast<CommandVerboseState*>(_state.get());

  DoLog(0) && (Log() << Verbose(0) << "Setting verbosity from " << state->oldverbosity << " to " << state->params.verbosity << "." << endl);
  setVerbosity(state->params.verbosity);

  return Action::state_ptr(_state);
}

bool CommandVerboseAction::canUndo() {
  return true;
}

bool CommandVerboseAction::shouldUndo() {
  return true;
}

const string CommandVerboseAction::getName() {
  return NAME;
}
/** =========== end of function ====================== */
