/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * ElementDbAction.cpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "config.hpp"
#include "Helpers/Log.hpp"
#include "periodentafel.hpp"
#include "Helpers/Verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "Actions/CommandAction/ElementDbAction.hpp"

// and construct the stuff
#include "ElementDbAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr CommandElementDbAction::performCall() {
  ostringstream usage;

  // obtain information
  getParametersfromValueStorage();

  // get the path
  // TODO: Make databasepath a std::string
  config *configuration = World::getInstance().getConfig();
  strcpy(configuration->databasepath, params.databasepath.c_str());

  // load table
  periodentafel *periode = World::getInstance().getPeriode();
  if (periode->LoadPeriodentafel(configuration->databasepath)) {
    DoLog(0) && (Log() << Verbose(0) << "Element list loaded successfully." << endl);
    //periode->Output();
    return Action::success;
  } else {
    DoLog(0) && (Log() << Verbose(0) << "Element list loading failed." << endl);
    return Action::failure;
  }

}

Action::state_ptr CommandElementDbAction::performUndo(Action::state_ptr _state) {
//  ParserLoadXyzState *state = assert_cast<ParserLoadXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserLoadXyzState(state->mol,newName));
}

Action::state_ptr CommandElementDbAction::performRedo(Action::state_ptr _state){
  return Action::failure;
}

bool CommandElementDbAction::canUndo() {
  return false;
}

bool CommandElementDbAction::shouldUndo() {
  return false;
}

const string CommandElementDbAction::getName() {
  return NAME;
}
/** =========== end of function ====================== */
