/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * BondLengthTableAction.cpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "bondgraph.hpp"
#include "config.hpp"
#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "Actions/CommandAction/BondLengthTableAction.hpp"

// and construct the stuff
#include "BondLengthTableAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr CommandBondLengthTableAction::performCall() {
  ostringstream usage;

  // obtain information
  getParametersfromValueStorage();

  DoLog(0) && (Log() << Verbose(0) << "Using " << params.BondGraphFileName << " as bond length table." << endl);
  config *configuration = World::getInstance().getConfig();
  if (configuration->BG == NULL) {
    configuration->BG = new BondGraph(configuration->GetIsAngstroem());
    if ((!params.BondGraphFileName.empty()) && (configuration->BG->LoadBondLengthTable(params.BondGraphFileName))) {
      DoLog(0) && (Log() << Verbose(0) << "Bond length table loaded successfully." << endl);
      return Action::success;
    } else {
      DoeLog(1) && (eLog()<< Verbose(1) << "Bond length table loading failed." << endl);
      return Action::failure;
    }
  } else {
    DoLog(0) && (Log() << Verbose(0) << "Bond length table already present." << endl);
    return Action::failure;
  }
}

Action::state_ptr CommandBondLengthTableAction::performUndo(Action::state_ptr _state) {
//  ParserLoadXyzState *state = assert_cast<ParserLoadXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserLoadXyzState(state->mol,newName));
}

Action::state_ptr CommandBondLengthTableAction::performRedo(Action::state_ptr _state){
  return Action::failure;
}

bool CommandBondLengthTableAction::canUndo() {
  return false;
}

bool CommandBondLengthTableAction::shouldUndo() {
  return false;
}

const string CommandBondLengthTableAction::getName() {
  return NAME;
}
/** =========== end of function ====================== */
