/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * PairCorrelationAction.cpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "analysis_correlation.hpp"
#include "boundary.hpp"
#include "linkedcell.hpp"
#include "Helpers/Verbose.hpp"
#include "Helpers/Log.hpp"
#include "element.hpp"
#include "molecule.hpp"
#include "periodentafel.hpp"
#include "LinearAlgebra/Vector.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "Actions/AnalysisAction/PairCorrelationAction.hpp"

// and construct the stuff
#include "PairCorrelationAction.def"
#include "Action_impl_pre.hpp"

/** =========== define the function ====================== */
Action::state_ptr AnalysisPairCorrelationAction::performCall() {
  int ranges[3] = {1, 1, 1};
  ofstream output;
  ofstream binoutput;
  string type;
  BinPairMap *binmap = NULL;

  // obtain information
  getParametersfromValueStorage();

  // execute action
  output.open(params.outputname.c_str());
  binoutput.open(params.binoutputname.c_str());
  PairCorrelationMap *correlationmap = NULL;
  std::vector<molecule*> molecules = World::getInstance().getSelectedMolecules();
  if (params.periodic)
    correlationmap = PeriodicPairCorrelation(molecules, params.elements, ranges);
  else
    correlationmap = PairCorrelation(molecules, params.elements);
  OutputPairCorrelation(&output, correlationmap);
  binmap = BinData( correlationmap, params.BinWidth, params.BinStart, params.BinEnd );
  OutputCorrelation ( &binoutput, binmap );
  delete(binmap);
  delete(correlationmap);
  output.close();
  binoutput.close();
  return Action::success;
}

Action::state_ptr AnalysisPairCorrelationAction::performUndo(Action::state_ptr _state) {
  return Action::success;
}

Action::state_ptr AnalysisPairCorrelationAction::performRedo(Action::state_ptr _state){
  return Action::success;
}

bool AnalysisPairCorrelationAction::canUndo() {
  return true;
}

bool AnalysisPairCorrelationAction::shouldUndo() {
  return true;
}

const string AnalysisPairCorrelationAction::getName() {
  return NAME;
}
/** =========== end of function ====================== */
