/*
 * Action_impl_header.hpp
 *
 *  Created on: Aug 25, 2010
 *      Author: heber
 */

#include <boost/preprocessor/cat.hpp>
#include <boost/preprocessor/comparison/equal.hpp>
#include <boost/preprocessor/comparison/not_equal.hpp>
#include <boost/preprocessor/control/if.hpp>
#include <boost/preprocessor/debug/assert.hpp>
#include <boost/preprocessor/iteration/local.hpp>
#include <boost/preprocessor/punctuation/comma_if.hpp>
#include <boost/preprocessor/repetition/repeat.hpp>
#include <boost/preprocessor/seq/elem.hpp>
#include <boost/preprocessor/seq/push_back.hpp>
#include <boost/preprocessor/seq/seq.hpp>
#include <boost/preprocessor/seq/size.hpp>
#include <boost/preprocessor/seq/transform.hpp>

// some derived names
#define ACTION BOOST_PP_CAT(CATEGORY, BOOST_PP_CAT(ACTIONNAME, Action))
#define COMMAND BOOST_PP_CAT(CATEGORY, ACTIONNAME)
#define PARAMS BOOST_PP_CAT(CATEGORY, BOOST_PP_CAT(ACTIONNAME, Parameters))

// check if no lists given
#ifndef paramtypes
#define MAXPARAMTYPES 0
#else
#define MAXPARAMTYPES BOOST_PP_SEQ_SIZE(paramtypes)
#endif

// check user has given name and category
#ifndef CATEGORY
ERROR: No "CATEGORY" defined in: __FILE__
#endif

#ifndef ACTIONNAME
ERROR: No "ACTIONNAME" defined in: __FILE__
#endif

// calculate numbers and check whether all have same size
#ifdef paramtokens
BOOST_PP_ASSERT_MSG(BOOST_PP_EQUAL(MAXPARAMTYPES, BOOST_PP_SEQ_SIZE(paramtokens)),\
  ERROR: There are not the same number of "paramtokens" and "paramtypes" in: __FILE__ \
)
#endif
#ifdef paramreferences
BOOST_PP_ASSERT_MSG(BOOST_PP_EQUAL(MAXPARAMTYPES, BOOST_PP_SEQ_SIZE(paramreferences)),\
  ERROR: There are not the same number of "paramtokens" and "paramreferences" in: __FILE__ \
)
#endif

// print a list of type ref followed by a separator, i.e. "int i;"
#define type_print(z,n,TYPELIST, VARLIST, separator) \
  BOOST_PP_SEQ_ELEM(n, TYPELIST) \
  BOOST_PP_SEQ_ELEM(n, VARLIST)\
  separator

// print a list of type ref followed, i.e. "int i, double position"
#define type_list(z,n,TYPELIST, VARLIST) \
  BOOST_PP_COMMA_IF(n)\
  BOOST_PP_SEQ_ELEM(n, TYPELIST) \
  BOOST_PP_SEQ_ELEM(n, VARLIST)

#if defined paramtypes && defined paramreferences
void COMMAND(
#define BOOST_PP_LOCAL_MACRO(n) type_list(~, n, paramtypes, paramreferences)
#define BOOST_PP_LOCAL_LIMITS  (0, MAXPARAMTYPES-1)
#include BOOST_PP_LOCAL_ITERATE()
    );
# else
void COMMAND();
#endif

class ACTION : public Action {
  friend
  #if defined paramtypes && defined paramreferences
  void COMMAND(
  #define BOOST_PP_LOCAL_MACRO(n) type_list(~, n, paramtypes, paramreferences)
  #define BOOST_PP_LOCAL_LIMITS  (0, MAXPARAMTYPES-1)
  #include BOOST_PP_LOCAL_ITERATE()
      );
  # else
  void COMMAND();
  #endif

public:
  ACTION();
  virtual ~ACTION();

  bool canUndo();
  bool shouldUndo();

  virtual const std::string getName();

  struct PARAMS : ActionParameters {
  #if defined paramtypes && defined paramreferences
  #define BOOST_PP_LOCAL_MACRO(n) type_print(~, n, paramtypes, paramreferences, ;)
  #define BOOST_PP_LOCAL_LIMITS  (0, MAXPARAMTYPES-1)
  #include BOOST_PP_LOCAL_ITERATE()
  #endif
  } params;

protected:
  virtual Dialog * fillDialog(Dialog*);
private:
  virtual void getParametersfromValueStorage();
  virtual Action::state_ptr performCall();
  virtual Action::state_ptr performUndo(Action::state_ptr);
  virtual Action::state_ptr performRedo(Action::state_ptr);

  static const char NAME[];
};

#undef paramtypes
#undef paramtokens
#undef paramreferences
#undef MAXPARAMTYPES
#undef statetypes
#undef statereferences
#undef MAXSTATETYPES

#undef ACTION
#undef COMMAND
#undef COMMANDFULL
#undef PARAMS

#undef ACTIONNAME
#undef CATEGORY
#undef TOKEN
