/*
 * ActionHistory.hpp
 *
 *  Created on: Mar 25, 2010
 *      Author: crueger
 */

#ifndef ACTIONHISTORY_HPP_
#define ACTIONHISTORY_HPP_

#include "Patterns/Singleton.hpp"

#include <deque>

#include "Actions/Action.hpp"


class ActionHistory : public Singleton<ActionHistory,false>
{
  friend class Singleton<ActionHistory,false>;

  struct HistoryElement {
    HistoryElement(Action *_action, Action::state_ptr _state) :
      action(_action),
      state(_state)
    {}
    Action *action;
    Action::state_ptr state;
  };

  class UndoAction : public Action {
  public:
    UndoAction(ActionHistory*);
    virtual ~UndoAction();

    virtual bool canUndo();
    virtual bool shouldUndo();

    virtual bool isActive();
  protected:
    virtual Dialog * fillDialog(Dialog *dialog);
  private:
    virtual void getParametersfromValueStorage();
  virtual Action::state_ptr performCall();
    virtual Action::state_ptr performUndo(Action::state_ptr);
    virtual Action::state_ptr performRedo(Action::state_ptr);

    ActionHistory *hist;

    static const char NAME[];
  };

  class RedoAction : public Action {
  public:
    RedoAction(ActionHistory*);
    virtual ~RedoAction();

    virtual bool canUndo();
    virtual bool shouldUndo();

    virtual bool isActive();

  protected:
    virtual Dialog * fillDialog(Dialog *dialog);
  private:
    virtual void getParametersfromValueStorage();
    virtual Action::state_ptr performCall();
    virtual Action::state_ptr performUndo(Action::state_ptr);
    virtual Action::state_ptr performRedo(Action::state_ptr);

    ActionHistory *hist;

    static const char NAME[];
  };

public:

  void undoLast();
  void redoLast();

  bool hasUndo();
  bool hasRedo();

  void addElement(Action*,Action::state_ptr);
  void clear();
protected:
  ActionHistory();
  virtual ~ActionHistory();
private:
  std::deque<HistoryElement> history;
  std::deque<HistoryElement> yrotsih;

public:
  // when constructing the actions we need the Actionregistry Singleton
  // Singletons need static variables to work, but we cannot access statics
  // inside a static initialization, so we have this init function that
  // needs to be called at a non-static point at the start of the program
  static void init();
};

#endif /* ACTIONHISTORY_HPP_ */
