/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * Action.cpp
 *
 *  Created on: Dec 8, 2009
 *      Author: crueger
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include <string>

#include "Actions/Action.hpp"
#include "Actions/ActionRegistry.hpp"
#include "Actions/ActionHistory.hpp"
#include "Exceptions/MissingValueException.hpp"
#include "UIElements/Dialog.hpp"
#include "Helpers/MemDebug.hpp"
#include "UIElements/UIFactory.hpp"

#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"

using namespace std;

Action::state_ptr getEmptyState() {
  return Action::state_ptr(Memory::ignore(new ActionState()));
}

// An empty state to indicate success
Action::state_ptr Action::success = getEmptyState();
Action::state_ptr Action::failure = getEmptyState();

Action::Action(std::string _name,bool _doRegister) :
name(_name)
{
  if(_doRegister){
    ActionRegistry::getInstance().registerInstance(this);
  }
}

Action::~Action()
{}

const string Action::getName(){
  return name;
}

Dialog * Action::createDialog(){
  Dialog *dialog = UIFactory::getInstance().makeDialog();
  return fillDialog(dialog);
}

void Action::call(enum QueryOptions flag){
  if(!isActive()){
    return;
  }
  // forward to private virtual
  if (flag == Interactive) {
    Dialog* dialog = createDialog();
    if (dialog->hasQueries()) {
      dialog->display();
    }
    delete(dialog);
  }
  state_ptr state = Action::failure;
//  try {
    state = performCall();
//  } catch(MissingValueException&) {
//    DoeLog(0) && (eLog() << Verbose(0) << "There is a value missing for action " << getName() << endl);
//  };

  if(shouldUndo() && state != failure){
    if(canUndo()){
      ActionHistory::getInstance().addElement(this,state);
    }
    else{
      ActionHistory::getInstance().clear();
    }
  }
}
Action::state_ptr Action::undo(state_ptr _state) {
  // forward to private virtual
  return performUndo(_state);
}
Action::state_ptr Action::redo(state_ptr _state) {
  // forward to private virtual
  return performRedo(_state);
}


bool Action::isActive(){
  return true;
}
