/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * IsInsideDomain_FillPredicateUnitTest.cpp
 *
 *  Created on: Jan 19, 2012
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include "CodePatterns/Assert.hpp"

#include "Box.hpp"
#include "Filling/Predicates/IsInsideDomain_FillPredicate.hpp"
#include "LinearAlgebra/RealSpaceMatrix.hpp"
#include "Filling/NodeTypes.hpp"

#include "IsInsideDomain_FillPredicateUnitTest.hpp"

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

/********************************************** Test classes **************************************/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( IsInsideDomain_FillPredicateTest );


void IsInsideDomain_FillPredicateTest::setUp()
{
  // failing asserts should be thrown
  ASSERT_DO(Assert::Throw);

  M = new RealSpaceMatrix;
  M->setIdentity();
  (*M) *= 20.;

  domain = new Box(*M);

  predicate = new FillPredicate(IsInsideDomain_FillPredicate(*domain));
}


void IsInsideDomain_FillPredicateTest::tearDown()
{
  delete predicate;
  delete domain;
  delete M;
}

/** Test whether operator() returns as desired
 *
 */
void IsInsideDomain_FillPredicateTest::operatorTest()
{
  Node origin(0.,0.,0.);
  Node center(10.,10.,10.);
  Node corner(20.,20.,20.);
  Node outside(30.,30.,30.);

  {
    // origin is inside
    CPPUNIT_ASSERT( (*predicate)(origin) );

    // center is inside
    CPPUNIT_ASSERT( (*predicate)(center) );

    // corner is inside
    CPPUNIT_ASSERT( (*predicate)(corner) );

    // outside is outside
    CPPUNIT_ASSERT( !(*predicate)(outside) );
  }
}
