/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * IsInsideDomain_FillPredicate.cpp
 *
 *  Created on: Jan 19, 2012
 *      Author: heber
 */


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include <boost/bind.hpp>

#include "IsInsideDomain_FillPredicate.hpp"

#include "AnyFillPredicate.hpp"
#include "Box.hpp"
#include "FillPredicate.hpp"

FillPredicate IsInsideDomain_FillPredicate(const Box &domain)
{
  AnyFillPredicate::FillPredicator function = boost::bind(&Box::isInside, &domain, _1);
  FillPredicate::impl_ptr impl(new AnyFillPredicate(function));
  return FillPredicate(impl);
}
