/*
 * QtMoleculeItem_formula.hpp
 *
 *  Created on: Jan 18, 2015
 *      Author: heber
 */

#ifndef QTMOLECULEITEM_FORMULA_HPP_
#define QTMOLECULEITEM_FORMULA_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "UIElements/Views/Qt4/MoleculeList/QtMoleculeItem.hpp"

#include <string>

#include "Descriptors/MoleculeIdDescriptor.hpp"
#include "Formula.hpp"
#include "molecule.hpp"
#include "World.hpp"

class QtMoleculeItemFactory;

/** This class contains the formula of a molecule and keeps it up to date.
 *
 */
class QtMoleculeItem_formula : public QtMoleculeItem
{
  //!> only allow factory to instantiate items
  friend class QtMoleculeItemFactory;

  QtMoleculeItem_formula(
      const moleculeId_t _molid,
      emitDirtyState_t _emitDirtyState) :
        QtMoleculeItem(_molid, channellist_formula, QtMoleculeItem::NeedsMove, _emitDirtyState)
  {
    // cannot call pure virtual function in QtMoleculeItem's cstor
    internal_updateState();
  }

  /** Performs the update of the molecule's formula.
   *
   */
  void internal_updateState()
  {
    const molecule * mol = const_cast<const World &>(World::getInstance()).
        getMolecule(MoleculeById(molid));
    if (mol != NULL)
      setText(QString(mol->getFormula().toString().c_str()));
    else
      setText(QString(""));
  }

  //!> notification channels of molecule specific to this molecule item, required for update
  static const QtMoleculeItem::channellist_t channellist_formula;
};



#endif /* QTMOLECULEITEM_FORMULA_HPP_ */
