/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * SaveSelectedMoleculesAction.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "Parser/FormatParserStorage.hpp"

#include <iostream>
#include <string>

#include <boost/filesystem/fstream.hpp>

using namespace std;

#include "SaveSelectedMoleculesAction.hpp"

// and construct the stuff
#include "SaveSelectedMoleculesAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr MoleculeSaveSelectedMoleculesAction::performCall() {
  // obtain information
  getParametersfromValueStorage();

  DoLog(1) && (Log() << Verbose(1) << "Storing world to file " << params.filename << "." << endl);

  // extract suffix
  std::string FilenameSuffix;
  std::string FilenamePrefix;
  if (params.filename.has_filename()) {
    // get suffix
#if BOOST_VERSION >= 104600
      FilenameSuffix = params.filename.extension().string().substr(1); // remove the prefixed "."
      FilenamePrefix = params.filename.stem().string();
#else
      FilenameSuffix = params.filename.extension().substr(1); // remove the prefixed "."
      FilenamePrefix = params.filename.stem();
#endif
  } else {
    DoeLog(1) && (eLog() << Verbose(1) << "Output file does not have a suffix, cannot recognize format." << endl);
    return Action::failure;
  }

  // store file
  // parse the file
  boost::filesystem::ofstream output;
  output.open(params.filename);
  if (!output.fail()) {
    FormatParserStorage::getInstance().saveSelectedMolecules(output, FilenameSuffix);
  } else {
    DoeLog(1) && (eLog() << Verbose(1) << "Could not open file " << params.filename << "." << endl);
  }
  output.close();

  return Action::success;
}

Action::state_ptr MoleculeSaveSelectedMoleculesAction::performUndo(Action::state_ptr _state) {
//  ParserSaveXyzState *state = assert_cast<ParserSaveXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserSaveXyzState(state->mol,newName));
}

Action::state_ptr MoleculeSaveSelectedMoleculesAction::performRedo(Action::state_ptr _state){
  return Action::failure;
//  // Undo and redo have to do the same for this action
//  return performUndo(_state);
}

bool MoleculeSaveSelectedMoleculesAction::canUndo() {
  return false;
}

bool MoleculeSaveSelectedMoleculesAction::shouldUndo() {
  return false;
}
/** =========== end of function ====================== */
