/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * SaveBondsAction.cpp
 *
 *  Created on: May 10, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Graph/BondGraph.hpp"
#include "config.hpp"
#include "CodePatterns/Log.hpp"
#include "molecule.hpp"
#include "CodePatterns/Verbose.hpp"
#include "World.hpp"


#include <iostream>
#include <fstream>
#include <string>

using namespace std;

#include "Actions/MoleculeAction/SaveBondsAction.hpp"

// and construct the stuff
#include "SaveBondsAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr MoleculeSaveBondsAction::performCall() {
  molecule *mol = NULL;

  // obtain information
  getParametersfromValueStorage();

  for (World::MoleculeSelectionIterator iter = World::getInstance().beginMoleculeSelection(); iter != World::getInstance().endMoleculeSelection(); ++iter) {
    mol = iter->second;
    DoLog(0) && (Log() << Verbose(0) << "Storing bonds to path " << params.bondsfile << "." << endl);
    // TODO: sollte stream, nicht filenamen direkt nutzen, besser fuer unit tests
#if BOOST_VERSION >= 104600
    mol->StoreBondsToFile(params.bondsfile.leaf().string(), params.bondsfile.branch_path().string());
#else
    mol->StoreBondsToFile(params.bondsfile.leaf(), params.bondsfile.branch_path().string());
#endif
  }
  return Action::success;
}

Action::state_ptr MoleculeSaveBondsAction::performUndo(Action::state_ptr _state) {
//  MoleculeSaveBondsState *state = assert_cast<MoleculeSaveBondsState*>(_state.get());

//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);

  return Action::failure;
}

Action::state_ptr MoleculeSaveBondsAction::performRedo(Action::state_ptr _state){
  // Undo and redo have to do the same for this action
  return performUndo(_state);
}

bool MoleculeSaveBondsAction::canUndo() {
  return false;
}

bool MoleculeSaveBondsAction::shouldUndo() {
  return false;
}
/** =========== end of function ====================== */
