/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * LoadAction.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "Parser/FormatParserStorage.hpp"
#include "molecule.hpp"
#include "World.hpp"

#include <iostream>

#include <boost/filesystem/fstream.hpp>

using namespace std;

#include "LoadAction.hpp"

// and construct the stuff
#include "LoadAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr MoleculeLoadAction::performCall() {
  // obtain information
  getParametersfromValueStorage();

  // parsing file if present
  if (!boost::filesystem::exists(params.filename)) {
    DoLog(1) && (Log() << Verbose(1) << "Specified input file " << params.filename << " not found." << endl);
    // DONT FAIL: it's just empty and we use the name. // return Action::failure;
  } else {
    DoLog(1) && (Log() << Verbose(1) << "Specified input file found, parsing ... ");

    // extract suffix
    std::string FilenameSuffix;
    std::string FilenamePrefix;
    if (params.filename.has_filename()) {
      // get suffix
#if BOOST_VERSION >= 104600
      FilenameSuffix = params.filename.extension().string().substr(1); // remove the prefixed "."
      FilenamePrefix = params.filename.stem().string();
#else
      FilenameSuffix = params.filename.extension().substr(1); // remove the prefixed "."
      FilenamePrefix = params.filename.stem();
#endif
    } else {
      DoeLog(1) && (eLog() << Verbose(1) << "Input file does not have a suffix, cannot recognize format." << endl);
      return Action::failure;
    }

    // parse the file
    boost::filesystem::ifstream input;
    input.open(params.filename);
    FormatParserStorage::getInstance().load(input, FilenameSuffix);
    input.close();

    // set file name of last molecule
    MoleculeList::const_reverse_iterator iter = World::getInstance().getMolecules()->ListOfMolecules.rbegin();
    (*iter)->SetNameFromFilename(FilenamePrefix.c_str());
    DoLog(0) && (Log() << Verbose(0) << "Chemical formula is " << (*iter)->getFormula() << std::endl);
  }
  return Action::success;
}

Action::state_ptr MoleculeLoadAction::performUndo(Action::state_ptr _state) {
//  ParserLoadXyzState *state = assert_cast<ParserLoadXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserLoadXyzState(state->mol,newName));
}

Action::state_ptr MoleculeLoadAction::performRedo(Action::state_ptr _state){
  return Action::failure;
}

bool MoleculeLoadAction::canUndo() {
  return true;
}

bool MoleculeLoadAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
