/*
 * VMGFragmentController.hpp
 *
 *  Created on: Aug 27, 2012
 *      Author: heber
 */

#ifndef VMGFRAGMENTCONTROLLER_HPP_
#define VMGFRAGMENTCONTROLLER_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Fragmentation/Automation/SpecificFragmentController.hpp"

#include <map>
#include <vector>

#include "JobMarket/types.hpp"

#include "Fragmentation/Summation/Containers/MPQCData.hpp"
#include "Fragmentation/Summation/Containers/VMGData.hpp"
#include "Fragmentation/Summation/SetValues/Fragment.hpp"
#include "Fragmentation/Summation/SetValues/SamplingGrid.hpp"

/** This class uses SpecificFragmentController with functions to add specificly
 * VMGJobs.
 */
class VMGFragmentController : public SpecificFragmentController
{
public:
  VMGFragmentController(boost::asio::io_service &io_service) :
    SpecificFragmentController(io_service)
  {}
  virtual ~VMGFragmentController()
  {}

  //>! Enumerization of possible treatment of nuclei point charges.
  enum SampleParticles_t {
    DontSampleParticles=0,
    DoSampleParticles=1
  };

  //>! Enumerization of possible treatment of electronic charge distribution on grid.
  enum TreatGrid_t {
    DontTreatGrid=0,
    DoTreatGrid=1
  };

  /** Creates the long range jobs from finished short-range jobs.
   *
   * \param fragmentData finished short-range results
   * \param full_sampled_grid sampled electron densities from finished short-range jobs
   * \param near_field_cells radius of b-splines for interpolation charges onto grid
   * \param interpolation_degree interpolation degree for newton interpolation from grid
   * \param _SampleParticles whether to add nuclei charges to vmg calculation.
   * \param _TreatGrid whether to add electron charge distribution to vmg calculation.
   * \param _DoValenceOnly whether to neglect core electron and nuclei charges
   * \param _DoPrintDebug whether we do print grid for debug visualization or not
   * \param _OpenBoundaryConditions whether we have open (true) or periodic (false)
   *        boundary conditions
   */
  bool createLongRangeJobs(
      const std::map<JobId_t, MPQCData> &fragmentData,
      const std::vector<SamplingGrid> &full_sampled_grid,
      const size_t near_field_cells,
      const size_t interpolation_degree,
      const SampleParticles_t _SampleParticles,
      const TreatGrid_t _TreatGrid,
      const MPQCData::DoValenceOnly_t _DoValenceOnly,
      const bool _DoPrintDebug,
      const bool _OpenBoundaryConditions = false);

  void waitforResults(const size_t NoExpectedResults)
  { results.waitforResults(NoExpectedResults, io_service, *this); }

  /** Get results of finished long-range jobs.
   *
   * \param fragmentData contains results on return
   */
  void getResults(std::map<JobId_t, VMGData> &fragmentData) {
    fragmentData = results.IdData;
    results.clear();
  }

private:
  //!> type-specific result container
  SpecificFragmentController::ResultContainer<VMGData> results;
};


#endif /* VMGFRAGMENTCONTROLLER_HPP_ */
