/*
 * SpecificFragmentController.hpp
 *
 *  Created on: Aug 27, 2012
 *      Author: heber
 */

#ifndef SPECIFICFRAGMENTCONTROLLER_HPP_
#define SPECIFICFRAGMENTCONTROLLER_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "JobMarket/Controller/FragmentController.hpp"
#include "JobMarket/types.hpp"
#include "JobMarket/Results/FragmentResult.hpp"

#include <map>
#include <string>
#include <vector>

/** This class extends FragmentController by some commodity functions used
 * within FragmentationAutomationAction.
 *
 */
class SpecificFragmentController : public FragmentController
{
public:
  SpecificFragmentController(boost::asio::io_service &_io_service) :
    FragmentController(_io_service),
    io_service(_io_service)
  {}

  virtual ~SpecificFragmentController()
  {}

  void requestIds(const size_t numberjobs);
  virtual void waitforResults(const size_t NoExpectedResults)=0;
  void RunService(const std::string message);

  /// getter and setter

  void setHost(const std::string &_host) { host = _host; }
  void setPort(const std::string &_port) { port = _port; }

protected:

  /** Container for the results received from the server.
   *
   * These are received bit by bit until all jobs are calculated.
   * This struct takes of the waiting.
   *
   */
  template <typename T>
  struct ResultContainer {
    /** cycle to wait for results
     *
     * \param NoExpectedResults number of expected results
     * \param io_service service used for waiting
     * \param callback ref to call controller functions
     */
    void waitforResults(
        const size_t NoExpectedResults,
        boost::asio::io_service &io_service,
        SpecificFragmentController &callback);

    /** Internal function to receive results if some are present.
     *
     * \param callback ref to call controller functions
     * \return number of received results
     */
    size_t receiveResults(SpecificFragmentController &callback);

    /** Extracts specific Data type from received vector of FragmentResults.
     *
     * @param results results to extract specific Data type from
     * @param fragmentData on return array filled with extracted specific Data type
     */
    void ConvertFragmentResultTo(
        const std::vector<FragmentResult::ptr> &results,
        std::vector<T> &fragmentData);

    /** Clears all internally stored results.
     *
     */
    void clear()
    { IdData.clear(); }

    //!> internal container for the received data
    std::map<JobId_t, T> IdData;
  };

protected:
  //!> hostname of the server to control
  std::string host;
  //!> port of the server to control
  std::string port;
  //!> reference to io_service for internal purposes
  boost::asio::io_service &io_service;
};

#include "SpecificFragmentController_ResultContainer_impl.hpp"

#endif /* SPECIFICFRAGMENTCONTROLLER_HPP_ */
