/*
 * MPQCFragmentController.hpp
 *
 *  Created on: Aug 27, 2012
 *      Author: heber
 */

#ifndef MPQCFRAGMENTCONTROLLER_HPP_
#define MPQCFRAGMENTCONTROLLER_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Fragmentation/Automation/SpecificFragmentController.hpp"

#include <boost/filesystem/path.hpp>

#include <fstream>
#include <string>
#include <vector>

#include "JobMarket/types.hpp"

#include "Fragmentation/Summation/Containers/MPQCData.hpp"

/** This class uses SpecificFragmentController with functions to add specificly
 * VMGJobs.
 */
class MPQCFragmentController : public SpecificFragmentController
{
public:
  MPQCFragmentController(boost::asio::io_service &io_service) :
    SpecificFragmentController(io_service)
  {}
  virtual ~MPQCFragmentController()
  {}

  /** Command Controller to fill its hold of jobs from FragmentJobQueue.
   *
   * \param _DoSampleDensity whether to actually sample the resulting electronic density
   * \param _DoValenceOnly whether to sample just the valence or the total elctron and nuclei density
   * \return true - jobs obtained, false - queue empty
   */
  bool addJobsFromQueue(
      const MPQCData::DoLongrange_t _DoLongrange,
      const MPQCData::DoValenceOnly_t _DoValenceOnly
      );

  void waitforResults(const size_t NoExpectedResults)
  { results.waitforResults(NoExpectedResults, io_service, *this); }

  /** Get results map of calculated jobs.
   *
   * \param fragmentData contains map of results on output
   */
  void getResults(std::map<JobId_t, MPQCData> &fragmentData) {
    fragmentData = results.IdData;
    results.clear();
  }

  /** Runs the service.
   *
   * Here, we finalize each job's id and push them to the server.
   */
  void run();

private:
  //!> type-specific result container
  SpecificFragmentController::ResultContainer<MPQCData> results;
};


#endif /* MPQCFRAGMENTCONTROLLER_HPP_ */
