/*
 * SaveXyzAction.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/ParserAction/SaveXyzAction.hpp"
#include "Parser/XyzParser.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/MapOfActions.hpp"

#include "atom.hpp"
#include "molecule.hpp"

/****** ParserSaveXyzAction *****/

//// memento to remember the state when undoing
//
//class ParserSaveXyzState : public ActionState {
//public:
//  ParserSaveXyzState(molecule* _mol,std::string _lastName) :
//    mol(_mol),
//    lastName(_lastName)
//  {}
//  molecule* mol;
//  std::string lastName;
//};

const char ParserSaveXyzAction::NAME[] = "SaveXyz";

ParserSaveXyzAction::ParserSaveXyzAction() :
  Action(NAME)
{}

ParserSaveXyzAction::~ParserSaveXyzAction()
{}

Action::state_ptr ParserSaveXyzAction::performCall() {
  string filename;
  XyzParser parser;
  Dialog *dialog = UIFactory::getInstance().makeDialog();

  dialog->queryString("filename",&filename, "Filename of the xyz file");

  if(dialog->display()) {
    // store xyz file
    ofstream output;
    output.open(filename.c_str());
    if (!output.fail())
      parser.save(&output);
    output.close();
  }
  delete dialog;
  return Action::failure;
}

Action::state_ptr ParserSaveXyzAction::performUndo(Action::state_ptr _state) {
//  ParserSaveXyzState *state = assert_cast<ParserSaveXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserSaveXyzState(state->mol,newName));
}

Action::state_ptr ParserSaveXyzAction::performRedo(Action::state_ptr _state){
  return Action::failure;
//  // Undo and redo have to do the same for this action
//  return performUndo(_state);
}

bool ParserSaveXyzAction::canUndo() {
  return false;
}

bool ParserSaveXyzAction::shouldUndo() {
  return false;
}

const string ParserSaveXyzAction::getName() {
  return NAME;
}
