/*
 * LoadXyzAction.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/ParserAction/LoadXyzAction.hpp"
#include "Parser/XyzParser.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/MapOfActions.hpp"

#include "atom.hpp"
#include "molecule.hpp"

/****** ParserLoadXyzAction *****/

//// memento to remember the state when undoing
//
//class ParserLoadXyzState : public ActionState {
//public:
//  ParserLoadXyzState(molecule* _mol,std::string _lastName) :
//    mol(_mol),
//    lastName(_lastName)
//  {}
//  molecule* mol;
//  std::string lastName;
//};

const char ParserLoadXyzAction::NAME[] = "LoadXyz";

ParserLoadXyzAction::ParserLoadXyzAction() :
  Action(NAME)
{}

ParserLoadXyzAction::~ParserLoadXyzAction()
{}

Action::state_ptr ParserLoadXyzAction::performCall() {
  string filename;
  XyzParser parser;
  Dialog *dialog = UIFactory::getInstance().makeDialog();

  dialog->queryString("filename",&filename, "Filename of the xyz file");

  if(dialog->display()) {
    // parse xyz file
    ifstream input;
    input.open(filename.c_str());
    if (!input.fail())
      parser.load(&input);
    input.close();
  }
  delete dialog;
  return Action::failure;
}

Action::state_ptr ParserLoadXyzAction::performUndo(Action::state_ptr _state) {
//  ParserLoadXyzState *state = assert_cast<ParserLoadXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserLoadXyzState(state->mol,newName));
}

Action::state_ptr ParserLoadXyzAction::performRedo(Action::state_ptr _state){
  return Action::failure;
}

bool ParserLoadXyzAction::canUndo() {
  return false;
}

bool ParserLoadXyzAction::shouldUndo() {
  return false;
}

const string ParserLoadXyzAction::getName() {
  return NAME;
}
