#ifndef VECTOR_HPP_
#define VECTOR_HPP_

using namespace std;

/*********************************************** includes ***********************************/

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gsl/gsl_vector.h>
#include <gsl/gsl_multimin.h>

#include "defs.hpp"

/********************************************** declarations *******************************/

/** Single vector.
 * basically, just a x[3] but with helpful functions
 */
class Vector {
  public:
    double x[NDIM];

  Vector();
  Vector(double x1, double x2, double x3);
  ~Vector();

  double Distance(const Vector *y) const;
  double DistanceSquared(const Vector *y) const;
  double DistanceToPlane(ofstream *out, Vector *PlaneNormal, Vector *PlaneOffset);
  double PeriodicDistance(const Vector *y, const double *cell_size) const;
  double PeriodicDistanceSquared(const Vector *y, const double *cell_size) const;
  double ScalarProduct(const Vector *y) const;
  double Norm() const;
  double NormSquared() const;
  double Angle(const Vector *y) const;
  bool IsZero() const;
  bool IsOne() const;
  bool IsNormalTo(const Vector *normal) const;

  void AddVector(const Vector *y);
  void SubtractVector(const Vector *y);
  void CopyVector(const Vector *y);
  void CopyVector(const Vector y);
  void RotateVector(const Vector *y, const double alpha);
  void VectorProduct(const Vector *y);
  void ProjectOntoPlane(const Vector *y);
  void ProjectIt(const Vector *y);
  Vector Projection(const Vector *y) const;
  void Zero();
  void One(double one);
  void Init(double x1, double x2, double x3);
  void Normalize();
  void Translate(const Vector *x);
  void Mirror(const Vector *x);
  void Scale(double **factor);
  void Scale(double *factor);
  void Scale(double factor);
  void MatrixMultiplication(const double *M);
  double * InverseMatrix(double *A);
  void InverseMatrixMultiplication(const double *M);
  void KeepPeriodic(ofstream *out, double *matrix);
  void LinearCombinationOfVectors(const Vector *x1, const Vector *x2, const Vector *x3, double *factors);
  double CutsPlaneAt(Vector *A, Vector *B, Vector *C);
  bool GetIntersectionWithPlane(ofstream *out, Vector *PlaneNormal, Vector *PlaneOffset, Vector *Origin, Vector *LineVector);
  bool GetIntersectionOfTwoLinesOnPlane(ofstream *out, Vector *Line1a, Vector *Line1b, Vector *Line2a, Vector *Line2b, const Vector *Normal = NULL);
  bool GetOneNormalVector(const Vector *x1);
  bool MakeNormalVector(const Vector *y1);
  bool MakeNormalVector(const Vector *y1, const Vector *y2);
  bool MakeNormalVector(const Vector *x1, const Vector *x2, const Vector *x3);
  bool SolveSystem(Vector *x1, Vector *x2, Vector *y, double alpha, double beta, double c);
  bool LSQdistance(Vector **vectors, int dim);
  void AskPosition(double *cell_size, bool check);
  bool Output(ofstream *out) const;
  bool IsInParallelepiped(Vector offset, double *parallelepiped);
  void WrapPeriodically(const double *M, const double *Minv);
};

ostream & operator << (ostream& ost, const Vector &m);
bool operator==(const Vector& a, const Vector& b);
Vector& operator+=(Vector& a, const Vector& b);
Vector& operator-=(Vector& a, const Vector& b);
Vector& operator*=(Vector& a, const double m);
Vector& operator*(const Vector& a, const double m);
Vector& operator*(const double m, const Vector& a);
Vector& operator+(const Vector& a, const Vector& b);
Vector& operator-(const Vector& a, const Vector& b);

// some algebraic matrix stuff
#define RDET3(a) ((a)[0]*(a)[4]*(a)[8] + (a)[3]*(a)[7]*(a)[2] + (a)[6]*(a)[1]*(a)[5] - (a)[2]*(a)[4]*(a)[6] - (a)[5]*(a)[7]*(a)[0] - (a)[8]*(a)[1]*(a)[3])  //!< hard-coded determinant of a 3x3 matrix
#define RDET2(a0,a1,a2,a3) ((a0)*(a3)-(a1)*(a2))                      //!< hard-coded determinant of a 2x2 matrix



#endif /*VECTOR_HPP_*/
