/*
 * AnalysisPairCorrelationUnitTest.hpp
 *
 *  Created on: Oct 13, 2009
 *      Author: heber
 */

#ifndef ANALYSISPAIRCORRELATIONUNITTEST_HPP_
#define ANALYSISPAIRCORRELATIONUNITTEST_HPP_

#include <cppunit/extensions/HelperMacros.h>

class element;
class molecule;
class LinkedCell;
class periodentafel;
class Tesselation;
class Vector;

/********************************************** Test classes **************************************/

class AnalysisPairCorrelationUnitTest : public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( AnalysisPairCorrelationUnitTest ) ;
    CPPUNIT_TEST ( PairCorrelationTest );
    CPPUNIT_TEST ( PairCorrelationBinNoRangeTest );
    CPPUNIT_TEST ( PairCorrelationBinRangeTest );
    CPPUNIT_TEST_SUITE_END();

public:
      void setUp();
      void tearDown();
      void PairCorrelationTest();
      void PairCorrelationBinNoRangeTest();
      void PairCorrelationBinRangeTest();

private:

      molecule *TestMolecule;
      element *hydrogen;
      periodentafel *tafel;

      PairCorrelationMap *correlationmap;
      BinPairMap *binmap;
};

#endif /* ANALYSISPAIRCORRELATIONUNITTEST_HPP_ */
