/*
 * AnalysisCorrelationToSurfaceUnitTest.hpp
 *
 *  Created on: Oct 13, 2009
 *      Author: heber
 */

#ifndef ANALYSISCORRELATIONTOSURFACEUNITTEST_HPP_
#define ANALYSISCORRELATIONTOSURFACEUNITTEST_HPP_

#include <cppunit/extensions/HelperMacros.h>

class element;
class molecule;
class LinkedCell;
class periodentafel;
class Tesselation;

/********************************************** Test classes **************************************/

class AnalysisCorrelationToSurfaceUnitTest : public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( AnalysisCorrelationToSurfaceUnitTest ) ;
    CPPUNIT_TEST ( CorrelationToSurfaceTest );
    CPPUNIT_TEST ( CorrelationToSurfaceBinNoRangeTest );
    CPPUNIT_TEST ( CorrelationToSurfaceBinRangeTest );
    CPPUNIT_TEST_SUITE_END();

public:
      void setUp();
      void tearDown();
      void CorrelationToSurfaceTest();
      void CorrelationToSurfaceBinNoRangeTest();
      void CorrelationToSurfaceBinRangeTest();

private:

      molecule *TestMolecule;
      element *hydrogen;
      periodentafel *tafel;

      CorrelationToSurfaceMap *surfacemap;
      BinPairMap *binmap;
      Tesselation *Surface;
      LinkedCell *LC;
};

#endif /* ANALYSISCORRELATIONTOSURFACEUNITTEST_HPP_ */
