/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * InputAction.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "Helpers/Log.hpp"
#include "molecule.hpp"
#include "Parser/FormatParserStorage.hpp"
#include "Parser/PcpParser.hpp"
#include "Helpers/Verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

#include <boost/filesystem/fstream.hpp>

using namespace std;

#include "Actions/WorldAction/InputAction.hpp"

// and construct the stuff
#include "InputAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr WorldInputAction::performCall() {
//  MoleculeListClass *molecules = World::getInstance().getMolecules();
//  molecule *mol = NULL;
  boost::filesystem::ifstream test;

  // obtain information
  getParametersfromValueStorage();

  DoLog(0) && (Log() << Verbose(0) << "Config file given " << params.filename << "." << endl);
  // using the filename as prefix for all parsers
  std::string FilenameSuffix;
  std::string FilenamePrefix;
  if (params.filename.has_filename()) {
    // get suffix
    FilenameSuffix = params.filename.extension().substr(1); // remove the prefixed "."
    FilenamePrefix = params.filename.stem();
    DoLog(1) && (Log() << Verbose(1) << "Setting config file name prefix to " << FilenamePrefix << "." << endl);
    FormatParserStorage::getInstance().SetOutputPrefixForAll(FilenamePrefix);
  } else {
    DoeLog(1) && (eLog() << Verbose(1) << "Input file does not have a suffix, cannot recognize format." << endl);
    return Action::failure;
  }

  // parsing file if present
  if (!boost::filesystem::exists(params.filename)) {
    DoLog(1) && (Log() << Verbose(1) << "Specified config file " << params.filename << " not found." << endl);
    // DONT FAIL: it's just empty and we use the name. // return Action::failure;
  } else {
    DoLog(1) && (Log() << Verbose(1) << "Specified config file found, parsing ... ");

    // parse the file
    test.open(params.filename);
    FormatParserStorage::getInstance().get(test, FilenameSuffix);
    test.close();

    // set file name of last molecule
    MoleculeList::const_iterator iter = World::getInstance().getMolecules()->ListOfMolecules.end();
    iter--;
    (*iter)->SetNameFromFilename(FilenamePrefix.c_str());
  }
  return Action::success;
}

Action::state_ptr WorldInputAction::performUndo(Action::state_ptr _state) {
//  ParserLoadXyzState *state = assert_cast<ParserLoadXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserLoadXyzState(state->mol,newName));
}

Action::state_ptr WorldInputAction::performRedo(Action::state_ptr _state){
  return Action::failure;
}

bool WorldInputAction::canUndo() {
  return false;
}

bool WorldInputAction::shouldUndo() {
  return false;
}

const string WorldInputAction::getName() {
  return NAME;
}
/** =========== end of function ====================== */
