/*
 * Shape_impl.hpp
 *
 *  Created on: Jun 18, 2010
 *      Author: crueger
 */

#ifndef SHAPE_IMPL_HPP_
#define SHAPE_IMPL_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <vector>

#include "Shapes/Shape.hpp"
#include "LinearAlgebra/Line.hpp"
#include "LinearAlgebra/LineSegment.hpp"
#include "LinearAlgebra/LineSegmentSet.hpp"
#include "LinearAlgebra/Vector.hpp"


class Shape_impl {
public:
  Shape_impl(){};
  virtual ~Shape_impl(){};
  virtual bool isInside(const Vector &point)=0;
  virtual bool isOnSurface(const Vector &point)=0;
  virtual Vector getNormal(const Vector &point) throw(NotOnSurfaceException)=0;
  virtual LineSegmentSet getLineIntersections(const Line&)=0;
  virtual std::string toString()=0;
  virtual std::vector<Vector> getHomogeneousPointsOnSurface(const size_t N) const=0;
};

class Everywhere_impl : public Shape_impl {
public:
  virtual bool isInside(const Vector &point){
    return true;
  }
  virtual bool isOnSurface(const Vector &point){
    return false;
  }
  virtual Vector getNormal(const Vector &point) throw(NotOnSurfaceException){
    throw NotOnSurfaceException(__FILE__,__LINE__);
  }
  virtual LineSegmentSet getLineIntersections(const Line &line){
    LineSegmentSet res(line);
    res.insert(LineSegment(line.negEndpoint(),line.posEndpoint()));
    return res;
  }
  virtual std::string toString(){
    return "Everywhere()";
  }
  virtual std::vector<Vector> getHomogeneousPointsOnSurface(const size_t N) const {
    std::vector<Vector> PointsOnSurface;
    return PointsOnSurface;
  }
};

class Nowhere_impl : public Shape_impl {
  virtual bool isInside(const Vector &point){
    return false;
  }
  virtual bool isOnSurface(const Vector &point){
    return false;
  }
  virtual Vector getNormal(const Vector &point) throw(NotOnSurfaceException){
    throw NotOnSurfaceException(__FILE__,__LINE__);
  }
  virtual LineSegmentSet getLineIntersections(const Line &line){
    return LineSegmentSet(line);
  }
  virtual std::string toString(){
    return "Nowhere()";
  }
  virtual std::vector<Vector> getHomogeneousPointsOnSurface(const size_t N) const {
    std::vector<Vector> PointsOnSurface;
    return PointsOnSurface;
  }
};

class AndShape_impl : public Shape_impl {
public:
  AndShape_impl(const Shape::impl_ptr&, const Shape::impl_ptr&);
  virtual ~AndShape_impl();
  virtual bool isInside(const Vector &point);
  virtual bool isOnSurface(const Vector &point);
  virtual Vector getNormal(const Vector &point) throw(NotOnSurfaceException);
  virtual LineSegmentSet getLineIntersections(const Line&);
  virtual std::string toString();
  virtual std::vector<Vector> getHomogeneousPointsOnSurface(const size_t N) const;
private:
  Shape::impl_ptr lhs;
  Shape::impl_ptr rhs;
};

class OrShape_impl : public Shape_impl {
public:
  OrShape_impl(const Shape::impl_ptr&, const Shape::impl_ptr&);
  virtual ~OrShape_impl();
  virtual bool isInside(const Vector &point);
  virtual bool isOnSurface(const Vector &point);
  virtual Vector getNormal(const Vector &point) throw(NotOnSurfaceException);
  virtual LineSegmentSet getLineIntersections(const Line&);
  virtual std::string toString();
  virtual std::vector<Vector> getHomogeneousPointsOnSurface(const size_t N) const;
private:
  Shape::impl_ptr lhs;
  Shape::impl_ptr rhs;
};

class NotShape_impl : public Shape_impl {
public:
  NotShape_impl(const Shape::impl_ptr&);
  virtual ~NotShape_impl();
  virtual bool isInside(const Vector &point);
  virtual bool isOnSurface(const Vector &point);
  virtual Vector getNormal(const Vector &point) throw(NotOnSurfaceException);
  virtual LineSegmentSet getLineIntersections(const Line&);
  virtual std::string toString();
  virtual std::vector<Vector> getHomogeneousPointsOnSurface(const size_t N) const;
private:
  Shape::impl_ptr arg;
};

Shape::impl_ptr getShapeImpl(const Shape&);

#endif /* SHAPE_IMPL_HPP_ */
