/*
 * VectorContentUnittest.hpp
 *
 *  Created on: Jan 8, 2010
 *      Author: heber
 */

#ifndef VECTORCONTENTUNITTEST_HPP_
#define VECTORCONTENTUNITTEST_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <cppunit/extensions/HelperMacros.h>

#include "LinearAlgebra/VectorContent.hpp"

/********************************************** Test classes **************************************/

class VectorContentTest : public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( VectorContentTest) ;
    CPPUNIT_TEST (AccessTest );
    CPPUNIT_TEST (InitializaionTest );
    CPPUNIT_TEST (CopyTest );
    CPPUNIT_TEST (ExchangeTest );
    CPPUNIT_TEST (OperatorAlgebraTest );
    CPPUNIT_TEST (OperatorIsTest );
    CPPUNIT_TEST_SUITE_END();

public:
    void setUp();
    void tearDown();

    void AccessTest();
    void InitializaionTest();
    void CopyTest();
    void ExchangeTest();
    void OperatorIsTest();
    void OperatorAlgebraTest();

private:

    VectorContent *v;
};


#endif /* VECTORCONTENTUNITTEST_HPP_ */
