/*
 * Subspace.hpp
 *
 *  Created on: Nov 22, 2010
 *      Author: heber
 */

#ifndef SUBSPACE_HPP_
#define SUBSPACE_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <map>
#include <set>
#include <vector>
#include "Eigenspace.hpp"
#include "MatrixContent.hpp"
#include "VectorContent.hpp"
#include "unittests/SubspaceFactorizerUnitTest.hpp"

/** A subset of eigenvectors from an Eigenspace.
 *
 * In this class we regard a sub set of eigenvectors of an Eigenspace
 * which span a subspace of the eigenspace. This is used for diagonalization
 * of the Eigenspace's matrix in linear-scaling, subspace decomposition
 * schemes.
 *
 * Here, beyond the contents of Eigenspace, we need projection matrices from
 * and to this subspace and also mappings from the global indices to the local
 * indices, to identify local eigenvectors in this Subspace with their
 * counterparts in the full Eigenspace.
 *
 */
class Subspace : public Eigenspace
{
  // TODO: Remove if not needed anymore
  friend void SubspaceFactorizerUnittest::SubspaceTest();
public:
  typedef std::map<size_t, size_t> mapping;
  typedef std::set< boost::shared_ptr<Subspace> > subset;

  Subspace(indexset &_s, Eigenspace &_FullSpace);
  ~Subspace();

  // manipulate subsets
  bool addSubset(boost::shared_ptr<Subspace> &_s);
  bool removeSubset(boost::shared_ptr<Subspace> &_s);

  // solving
  void calculateEigenSubspace();

  // accessing
  const MatrixContent & getEigenvectorMatrixInFullSpace();
  const eigenvectorset & getEigenvectorsInFullSpace();
  const VectorContent getEigenvectorParallelToFullOne(size_t i);
  const double getEigenvalueOfEigenvectorParallelToFullOne(size_t i);
  const subset & getSubIndices() const;

private:

  void createLocalMapping();
  void invertLocalToGlobalMapping();
  void getSubspacematrixFromBigmatrix(const MatrixContent & bigmatrix);
  void sortEigenvectors();
  void correctEigenvectorsFromSubIndices();
  void correctProjectionMatricesFromSubIndices();
  void scaleEigenvectorsbyEigenvalue();
  void getNormofEigenvectorAsEigenvalue();
  void createProjectionMatrices();
  const MatrixContent projectFullspaceMatrixToSubspace(const MatrixContent &_fullmatrix) const;
  const MatrixContent projectSubspaceMatrixToFullspace(const MatrixContent &_subspacematrix) const;

  mapping LocalToGlobal;
  mapping GlobalToLocal;
  subset SubIndices;
  MatrixContent ProjectToSubspace;
  MatrixContent ProjectFromSubspace;
  Eigenspace &FullSpace;

  const VectorContent ZeroVector;
};


#endif /* SUBSPACE_HPP_ */
