/*
 * Space.hpp
 *
 *  Created on: Apr 30, 2010
 *      Author: crueger
 */

#ifndef SPACE_HPP_
#define SPACE_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


class Vector;

class Space
{
public:
  Space();
  virtual ~Space();

  /**
   * Calculates the distance between a Space and a Vector.
   */
  virtual double distance(const Vector &point) const=0;

  /**
   * get the closest point inside the space to another point
   */
  virtual Vector getClosestPoint(const Vector &point) const=0;

  /**
   * get the shortest Vector from a point to a Space.
   *
   * The Vector always points from the given Vector to the point in space
   * returned by Plane::getClosestPoint().
   */
  virtual Vector getVectorToPoint(const Vector &point) const;

  /**
   * Test wether a point is contained in the space.
   *
   * returns true, when the point lies inside and false
   * otherwise.
   */
  virtual bool isContained(const Vector &point) const;

  /**
   * Tests if this space contains the center of the coordinate system.
   */
  virtual bool hasZero() const;

};

#endif /* SPACE_HPP_ */
