/*
 * ChangeTracker.cpp
 *
 *  Created on: Mar 1, 2010
 *      Author: metzler
 */

#include "Helpers/MemDebug.hpp"

#include "ChangeTracker.hpp"

ChangeTracker* ChangeTracker::instance = NULL;

/**
 * Constructor. Signs on as an observer for the World.
 */
ChangeTracker::ChangeTracker() :
  Observable("ChangeTracker")
{
  isConsistent = true;
  World::getInstance().signOn(this);
}

/**
 * Destructor. Signs off from the World.
 */
ChangeTracker::~ChangeTracker() {
  World::getInstance().signOff(this);
}

/**
 * Returns the change tracker instance.
 *
 * \return this
 */
ChangeTracker* ChangeTracker::get() {
  if (instance == NULL) {
    instance = new ChangeTracker();
  }

  return instance;
}

/**
 * Destroys the change tracker instance. Be careful, the change tracker is a
 * singleton and destruction might lead to a loss of consistency.
 */
void ChangeTracker::destroy() {
  delete instance;
  instance = NULL;
}

/**
 * With this, the World can update the change tracker's state.
 */
void ChangeTracker::update(Observable *publisher) {
  isConsistent = false;
}

/**
 * Gets whether there are non-saved changes.
 *
 * \param true if there are any changes, false otherwise
 */
bool ChangeTracker::hasChanged() {
  return !isConsistent;
}

/**
 * Tells all observers (which are the different parsers) that they are supposed
 * to save the current state.
 */
void ChangeTracker::saveStatus() {
  if (hasChanged()) {
    notifyAll();
  }
}
