/*
 * MpqcParser.hpp
 *
 *  Created on: 12.06.2010
 *      Author: heber
 */

#ifndef MPQCPARSER_HPP_
#define MPQCPARSER_HPP_

#include "FormatParser.hpp"

#include <iostream>

/**
 * Loads a MPQC config file into the World and saves the World as a tremolo file.
 */
class MpqcParser : public FormatParser
{
public:
  MpqcParser();
  ~MpqcParser();
  void load(std::istream* file);
  void save(std::ostream* file);

  void setHessian(bool hessian);

private:
  // whether output with computing hessian is desired.
  bool HessianPresent;

  void saveSimple(std::ostream *file);
  void saveHessian(std::ostream *file);
};

#endif /* MPQCPARSER_HPP_ */
