/** \file FormatParserStorage.hpp
 *
 *  date: Jun, 22 2010
 *  author: heber
 *
 */

#ifndef FORMATPARSERSTORAGE_HPP_
#define FORMATPARSERSTORAGE_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Patterns/Singleton.hpp"

#include <string>
#include <vector>

class FormatParser;

// enum has to be outside of class for operator++ to be possible
enum ParserTypes { mpqc, pcp, tremolo, xyz, ParserTypes_end, ParserTypes_begin = mpqc };
typedef enum ParserTypes ParserTypes;

/** Increment operator for the enumeration ParserTypes to allow loops.
 * \param &type value
 * \return value incremented by one
 */
ParserTypes &operator++(ParserTypes &type) 
{ 
  return type = ParserTypes(type+1); 
}

class FormatParserStorage : public Singleton<FormatParserStorage> {
  friend class Singleton<FormatParserStorage>;
public:


  void AddMpqc();
  void AddPcp();
  void AddTremolo();
  void AddXyz();

  void SetOutputPrefixForAll(std::string &_prefix);
  void SaveAll();

private:
  // private constructors as this is a singleton
  FormatParserStorage();
  ~FormatParserStorage();
  
  // list of allocated parsers
  std::vector<FormatParser *> ParserList;

  // which parser is already present
  std::vector<bool> ParserPresent;

  // default suffix of each parser type
  std::vector<std::string> ParserSuffix;

  // prefix of the filenames to use on save
  std::string prefix;
};

#endif // FORMATPARSERSTORAGE_HPP_
