/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * CommandLineWindow.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include <boost/bind.hpp>

#include "CommandLineUI/CommandLineWindow.hpp"
#include "CommandLineUI/CommandLineStatusIndicator.hpp"

#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"

#include "Actions/Action.hpp"
#include "Actions/ActionQueue.hpp"

#include "UIElements/CommandLineUI/CommandLineParser.hpp"

#include <iostream>

using namespace MoleCuilder;

// TODO: see what code can be moved to a base class for Graphic and CommandLine Windows
CommandLineWindow::CommandLineWindow()
{
  // Add status indicators etc...
  statusIndicator = new CommandLineStatusIndicator();
}

CommandLineWindow::~CommandLineWindow()
{
  delete statusIndicator;
}

void CommandLineWindow::display() {
  ActionQueue &AQ = ActionQueue::getInstance();
  //cout << AR;

  // go through all possible actions
  for (std::list<std::string>::iterator CommandRunner = CommandLineParser::getInstance().SequenceOfActions.begin(); CommandRunner != CommandLineParser::getInstance().SequenceOfActions.end(); ++CommandRunner) {
    if (AQ.isActionKnownByName(*CommandRunner)) {
//      LOG1, "INFO: Checking presence of " << *CommandRunner << ": " << "queuing.");
      AQ.queueAction(*CommandRunner);
    } else {
//      LOG(1, "INFO: Checking presence of " << *CommandRunner << ": " << "absent.");
    }
  }
}

