/*
 * MPQCDataMap.hpp
 *
 *  Created on: 28.07.2012
 *      Author: heber
 */

#ifndef MPQCDATAMAP_HPP_
#define MPQCDATAMAP_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <boost/fusion/container/map.hpp>
#include <boost/mpl/list.hpp>

#include "Jobs/MPQCDataFused.hpp"

class Fragment;
class Histogram;
class IndexedVectors;
class SamplingGrid;

/// \note: We had to split up the map because boost::fusion only allows for
/// up to 9 template types.

/** This boost::fusion map defines key-value or rather key-type pairs with
 * which we associate all energy_t data members in MPQCData and their type.
 *
 * This lets us resolves any ambiguitites of types in MPQCData, e.g.
 * to know vector<double> is forces or energy_eigenvalues.
 *
 */
typedef boost::fusion::map<
    boost::fusion::pair<MPQCDataFused::energy_total, double>
  ,  boost::fusion::pair<MPQCDataFused::energy_nuclear_repulsion, double>
  ,  boost::fusion::pair<MPQCDataFused::energy_electron_coulomb, double>
  ,  boost::fusion::pair<MPQCDataFused::energy_electron_exchange, double>
  ,  boost::fusion::pair<MPQCDataFused::energy_correlation, double>
  ,  boost::fusion::pair<MPQCDataFused::energy_overlap, double>
  ,  boost::fusion::pair<MPQCDataFused::energy_kinetic, double>
  ,  boost::fusion::pair<MPQCDataFused::energy_hcore, double>
  ,  boost::fusion::pair<MPQCDataFused::energy_eigenvalues, Histogram >
> MPQCDataEnergyMap_t;

typedef boost::mpl::list<
    MPQCDataFused::energy_total,
    MPQCDataFused::energy_nuclear_repulsion,
    MPQCDataFused::energy_electron_coulomb,
    MPQCDataFused::energy_electron_exchange,
    MPQCDataFused::energy_correlation,
    MPQCDataFused::energy_overlap,
    MPQCDataFused::energy_kinetic,
    MPQCDataFused::energy_hcore,
    MPQCDataFused::energy_eigenvalues
> MPQCDataEnergyVector_t;

/** This boost::fusion map defines key-value or rather key-type pairs with
 * which we associate all forces data members in MPQCData and their type.
 *
 * This lets us resolves any ambiguitites of types in MPQCData, e.g.
 * to know vector<double> is forces or energy_eigenvalues.
 *
 */
typedef boost::fusion::map<
  boost::fusion::pair<MPQCDataFused::forces, IndexedVectors >
> MPQCDataForceMap_t;

typedef boost::mpl::list<
    MPQCDataFused::forces
> MPQCDataForceVector_t;

/** This boost::fusion map defines key-value or rather key-type pairs with
 * which we associate all sampled_grid data members in MPQCData and their type.
 *
 * This lets us resolves any ambiguitites of types in MPQCData, e.g.
 * to know vector<double> is forces or energy_eigenvalues.
 *
 */
typedef boost::fusion::map<
    boost::fusion::pair<MPQCDataFused::sampled_grid, SamplingGrid >
> MPQCDataGridMap_t;

typedef boost::mpl::list<
    MPQCDataFused::sampled_grid
> MPQCDataGridVector_t;

/** This boost::fusion map defines key-value or rather key-type pairs with
 * which we associate all sampled_grid data members in MPQCData and their type.
 *
 * This lets us resolves any ambiguitites of types in MPQCData, e.g.
 * to know vector<double> is forces or energy_eigenvalues.
 *
 */
typedef boost::fusion::map<
    boost::fusion::pair<MPQCDataFused::fragment, Fragment >
> MPQCDataFragmentMap_t;

typedef boost::mpl::list<
    MPQCDataFused::fragment
> MPQCDataFragmentVector_t;

/** This boost::fusion map defines key-value or rather key-type pairs with
 * which we associate all times_t data members in MPQCData and their type.
 *
 * This lets us resolves any ambiguitites of types in MPQCData, e.g.
 * to know vector<double> is forces or energy_eigenvalues.
 *
 */
typedef boost::fusion::map<
  boost::fusion::pair<MPQCDataFused::times_total_walltime, double >
  , boost::fusion::pair<MPQCDataFused::times_total_cputime, double >
  , boost::fusion::pair<MPQCDataFused::times_total_flops, double >
  , boost::fusion::pair<MPQCDataFused::times_gather_walltime, double >
  , boost::fusion::pair<MPQCDataFused::times_gather_cputime, double >
  , boost::fusion::pair<MPQCDataFused::times_gather_flops, double >
> MPQCDataTimeMap_t;

typedef boost::mpl::list<
    MPQCDataFused::times_total_walltime,
    MPQCDataFused::times_total_cputime,
    MPQCDataFused::times_total_flops,
    MPQCDataFused::times_gather_walltime,
    MPQCDataFused::times_gather_cputime,
    MPQCDataFused::times_gather_flops
> MPQCDataTimeVector_t;

#endif /* MPQCDATAMAP_HPP_ */
