/*
 * MPQCData_printKeyNames.hpp
 *
 *  Created on: 28.07.2012
 *      Author: heber
 */

#ifndef MPQCDATA_PRINTKEYNAMES_HPP_
#define MPQCDATA_PRINTKEYNAMES_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

//#include <iosfwd>
#include <string>

#include <boost/preprocessor/iteration/local.hpp>
#include <boost/preprocessor/seq/elem.hpp>
#include <boost/preprocessor/seq/seq.hpp>
#include <boost/preprocessor/seq/size.hpp>
#include <boost/preprocessor/stringize.hpp>

/** this is the boost::preprocessor::sequence of the keys in the boost::fusion::map
 *
 * Basically, every key appears here in brackets. If so, then the preprocessor magic
 * below will create a template specialization of the printName() function in the
 * namespace printKeyNames.
 */
#define tokensequence \
  (energy_total) \
	(energy_nuclear_repulsion) \
	(energy_electron_coulomb) \
  (energy_electron_exchange) \
	(energy_correlation) \
	(energy_overlap) \
	(energy_kinetic) \
	(energy_hcore) \
	(energy_eigenvalues) \
	(forces) \
	(sampled_grid) \
	(times_total_walltime) \
	(times_total_cputime) \
	(times_total_flops) \
  (times_gather_walltime) \
  (times_gather_cputime) \
  (times_gather_flops)

/// we take note of the number of keys in tokensequence as (local) loop bounds below
#ifndef tokensequence
#define MAXTOKENS 0
#else
#define MAXTOKENS BOOST_PP_SEQ_SIZE(tokensequence)
#endif

//!> this is the macro function which prints the specialized template function
#define printName_specializer(z, n, NAMESPACE, TOKENSEQ, NAMESEQ ) \
  template<> std::string printName< NAMESPACE :: BOOST_PP_SEQ_ELEM( n, TOKENSEQ ) >() { \
    return std::string( BOOST_PP_STRINGIZE( BOOST_PP_SEQ_ELEM( n, NAMESEQ ) ) ); \
  }

/** Specific namespace for all the specialized template functions that print
 * a useful name for each of the boost::fusion::map key.
 */
namespace printKeyNames {
  /* iterate (line-wise) over the sequence and spill out a specialized printName
   * for each member in the boost::fusion::map.
   */
#if defined tokensequence && defined MAXTOKENS && defined printName_specializer
#define BOOST_PP_LOCAL_MACRO(n) printName_specializer(~, n, MPQCDataFused, tokensequence, tokensequence)
#define BOOST_PP_LOCAL_LIMITS  (0, MAXTOKENS-1)
#include BOOST_PP_LOCAL_ITERATE()
#endif

}; /* namespace printKeyNames */

#undef tokensequence
#undef printName_specializer

#undef MAXTOKENS

#endif /* MPQCDATA_PRINTKEYNAMES_HPP_ */
