/*
 * MPQCData.hpp
 *
 *  Created on: Feb 08, 2012
 *      Author: heber
 */

#ifndef MPQCDATA_HPP_
#define MPQCDATA_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <boost/serialization/access.hpp>
#include <boost/serialization/vector.hpp>

#include <iosfwd>
#include <vector>

#include "Jobs/Grid/SamplingGrid.hpp"

class MPQCCommandJob;
class MPQCCommandJobTest;
class MPQCDataTest;

/** Internal class that holds the data and can be serialized.
 *
 */
class MPQCData {
  //!> allow MPQCCommandJob access to member variables directly
  friend class MPQCCommandJob;
  //!> grant MPQCCommandJob's unit test access
  friend class MPQCCommandJobTest;
  //!> grant unit test access
  friend class MPQCDataTest;
  //!> grant access to output stream operator
  friend std::ostream & operator<<(std::ostream &ost, const MPQCData &data);
public:
  /** Constructor for class MPQCData with full sampling information.
   *
   * \param _props properties of the grid
   */
  MPQCData(const SamplingGridProperties &_props);

  /** Default Constructor for class MPQCData.
   *
   */
  MPQCData();

  bool operator==(const MPQCData &other) const;

  bool operator!=(const MPQCData &other) const {
    return !(*this == other);
  }

  /// Energie structure
  struct energy_t {
    /** Constructor for struct energy_t, sets all to zero.
     *
     */
    energy_t();

    double total;
    double nuclear_repulsion;
    double electron_coulomb;
    double electron_exchange;
    double correlation;
    double overlap;
    double kinetic;
    double hcore;

    std::vector<double> eigenvalues;
  } energies;

  /// Forces
  typedef std::vector<double> vector_type;
  std::vector< vector_type  > forces;

  /// Density
  SamplingGrid sampled_grid;

  // nuclei positions and charges
  std::vector< std::vector<double> > positions;
  std::vector<double> charges;

  /// Timing structure
  struct times_t {
    /** Constructor for struct times_t, sets all to zero.
     *
     */
    times_t();

    double total_walltime;
    double total_cputime;
    double total_flops;
    double gather_walltime;
    double gather_cputime;
    double gather_flops;
  } times;

private:
  friend class boost::serialization::access;
  // serialization
  template <typename Archive>
  void serialize(Archive& ar, const unsigned int version)
  {
    ar & energies.total;
    ar & energies.nuclear_repulsion;
    ar & energies.electron_coulomb;
    ar & energies.electron_exchange;
    ar & energies.correlation;
    ar & energies.overlap;
    ar & energies.kinetic;
    ar & energies.hcore;
    ar & energies.eigenvalues;
    ar & forces;
    ar & sampled_grid;
    ar & positions;
    ar & charges;
    ar & times.total_walltime;
    ar & times.total_cputime;
    ar & times.total_flops;
    ar & times.gather_walltime;
    ar & times.gather_cputime;
    ar & times.gather_flops;
  }
};

std::ostream & operator<<(std::ostream &ost, const MPQCData &data);

#endif /* MPQCDATA_HPP_ */
