/*
 * SubgraphDissectionAction.cpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/FragmentationAction/SubgraphDissectionAction.hpp"
#include "Actions/ActionRegistry.hpp"
#include "atom.hpp"
#include "config.hpp"
#include "log.hpp"
#include "molecule.hpp"
#include "Descriptors/MoleculeDescriptor.hpp"
#include "stackclass.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/ValueStorage.hpp"

const char FragmentationSubgraphDissectionAction::NAME[] = "subgraph-dissect";

FragmentationSubgraphDissectionAction::FragmentationSubgraphDissectionAction() :
  Action(NAME)
{}

FragmentationSubgraphDissectionAction::~FragmentationSubgraphDissectionAction()
{}

void FragmentationSubgraphDissection() {
  ActionRegistry::getInstance().getActionByName(FragmentationSubgraphDissectionAction::NAME)->call(Action::NonInteractive);
};

Dialog* FragmentationSubgraphDissectionAction::fillDialog(Dialog *dialog) {
  ASSERT(dialog,"No Dialog given when filling action dialog");

  dialog->queryEmpty(NAME, MapOfActions::getInstance().getDescription(NAME));

  return dialog;
}


Action::state_ptr FragmentationSubgraphDissectionAction::performCall() {
  DoLog(1) && (Log() << Verbose(1) << "Dissecting molecular system into a set of disconnected subgraphs ... " << endl);
  // @TODO rather do the dissection afterwards
  MoleculeListClass *molecules = World::getInstance().getMolecules();
  molecules->DissectMoleculeIntoConnectedSubgraphs(World::getInstance().getPeriode(), World::getInstance().getConfig());
  return Action::success;
}

Action::state_ptr FragmentationSubgraphDissectionAction::performUndo(Action::state_ptr _state) {
//  ParserLoadXyzState *state = assert_cast<ParserLoadXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserLoadXyzState(state->mol,newName));
}

Action::state_ptr FragmentationSubgraphDissectionAction::performRedo(Action::state_ptr _state){
  return Action::failure;
}

bool FragmentationSubgraphDissectionAction::canUndo() {
  return false;
}

bool FragmentationSubgraphDissectionAction::shouldUndo() {
  return false;
}

const string FragmentationSubgraphDissectionAction::getName() {
  return NAME;
}
