/*
 * FragmentationAction.cpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

#include "Actions/FragmentationAction/FragmentationAction.hpp"
#include "atom.hpp"
#include "bondgraph.hpp"
#include "config.hpp"
#include "log.hpp"
#include "molecule.hpp"
#include "Descriptors/MoleculeDescriptor.hpp"
#include "stackclass.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/MapOfActions.hpp"

const char FragmentationFragmentationAction::NAME[] = "fragment-mol";

FragmentationFragmentationAction::FragmentationFragmentationAction() :
  Action(NAME)
{}

FragmentationFragmentationAction::~FragmentationFragmentationAction()
{}

Action::state_ptr FragmentationFragmentationAction::performCall() {
  Dialog *dialog = UIFactory::getInstance().makeDialog();
  clock_t start,end;
  molecule *mol = NULL;
  double distance = -1.;
  int order = 0;
  config *configuration = World::getInstance().getConfig();
  int ExitFlag = 0;

  cout << "pre-dialog"<< endl;
  dialog->queryMolecule(NAME, &mol, MapOfActions::getInstance().getDescription(NAME));
  dialog->queryDouble("distance", &distance, MapOfActions::getInstance().getDescription("distance"));
  dialog->queryInt("order", &order, MapOfActions::getInstance().getDescription("order"));

  if(dialog->display()) {
    cout << "POST-dialog"<< endl;
    ASSERT(mol != NULL, "No molecule has been picked for fragmentation.");
    DoLog(0) && (Log() << Verbose(0) << "Fragmenting molecule with bond distance " << distance << " angstroem, order of " << order << "." << endl);
    DoLog(0) && (Log() << Verbose(0) << "Creating connection matrix..." << endl);
    start = clock();
    mol->CreateAdjacencyList(distance, configuration->GetIsAngstroem(), &BondGraph::CovalentMinMaxDistance, NULL);
    DoLog(0) && (Log() << Verbose(0) << "Fragmenting molecule with current connection matrix ..." << endl);
    if (mol->hasBondStructure()) {
      ExitFlag = mol->FragmentMolecule(order, configuration);
    }
    World::getInstance().setExitFlag(ExitFlag);
    end = clock();
    DoLog(0) && (Log() << Verbose(0) << "Clocks for this operation: " << (end-start) << ", time: " << ((double)(end-start)/CLOCKS_PER_SEC) << "s." << endl);
    delete dialog;
    return Action::success;
  } else {
    delete dialog;
    return Action::failure;
  }
}

Action::state_ptr FragmentationFragmentationAction::performUndo(Action::state_ptr _state) {
//  ParserLoadXyzState *state = assert_cast<ParserLoadXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserLoadXyzState(state->mol,newName));
}

Action::state_ptr FragmentationFragmentationAction::performRedo(Action::state_ptr _state){
  return Action::failure;
}

bool FragmentationFragmentationAction::canUndo() {
  return false;
}

bool FragmentationFragmentationAction::shouldUndo() {
  return false;
}

const string FragmentationFragmentationAction::getName() {
  return NAME;
}
