/*
 * LinearSystemOfEquationsunittest.hpp
 *
 *  Created on: Jan 8, 2010
 *      Author: heber
 */

#ifndef LINEARSYSTEMOFEQUATIONSUNITTEST_HPP_
#define LINEARSYSTEMOFEQUATIONSUNITTEST_HPP_

#include <cppunit/extensions/HelperMacros.h>

#include "LinearAlgebra/LinearSystemOfEquations.hpp"

/********************************************** Test classes **************************************/

class LinearSystemOfEquationsTest : public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( LinearSystemOfEquationsTest) ;
    CPPUNIT_TEST ( InitializationTest );
    CPPUNIT_TEST ( SymmetricTest );
    CPPUNIT_TEST ( SolveSimpleTest );
    CPPUNIT_TEST ( SolveAdvancedTest );
    CPPUNIT_TEST_SUITE_END();

public:
    void setUp();
    void tearDown();

    void InitializationTest();
    void SymmetricTest();
    void SolveSimpleTest();
    void SolveAdvancedTest();

private:
    LinearSystemOfEquations *s;
};


#endif /* LINEARSYSTEMOFEQUATIONSUNITTEST_HPP_ */
