/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 *
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * RotateShapeAction.cpp
 *
 *  Created on: Nov 19, 2012
 *      Author: ankele
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "Shapes/ShapeRegistry.hpp"
#include "Shapes/ShapeOps.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"

#include <iostream>
#include <string>

#include "RotateShapeAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "RotateShapeAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr ShapeRotateShapeAction::performCall() {
  LOG(1, "Translating shapes in ShapeRegistry.");

  std::vector<Shape*> selectedShapes = ShapeRegistry::getInstance().getSelectedShapes();

  std::vector<Shape> old_shapes;

  RealSpaceMatrix rotation;
  rotation.setRotation(params.angle_x.get() * M_PI/180., params.angle_y.get() * M_PI/180., params.angle_z.get() * M_PI/180.);
  Vector translation = params.center.get() - (rotation * params.center.get());

  for (unsigned int i=0;i<selectedShapes.size();i++){
    old_shapes.push_back(*selectedShapes[i]);
    Shape s = translate(transform(*selectedShapes[i], rotation), translation);
    std::string name = selectedShapes[i]->getName();
    s.setName(name);
    ShapeRegistry::getInstance().removeShape(name);
    ShapeRegistry::getInstance().addShape(s);
    ShapeRegistry::getInstance().selectShape(name);
  }

  return Action::state_ptr(new ShapeRotateShapeState(old_shapes, params));
}

Action::state_ptr ShapeRotateShapeAction::performUndo(Action::state_ptr _state) {
  ShapeRotateShapeState *state = assert_cast<ShapeRotateShapeState*>(_state.get());

  for (unsigned int i=0;i<state->old_shapes.size();i++){
    std::string name = state->old_shapes[i].getName();
    ShapeRegistry::getInstance().removeShape(name);
    ShapeRegistry::getInstance().addShape(state->old_shapes[i]);
    ShapeRegistry::getInstance().selectShape(name);
  }

  return Action::state_ptr(_state);
}

Action::state_ptr ShapeRotateShapeAction::performRedo(Action::state_ptr _state){
  ShapeRotateShapeState *state = assert_cast<ShapeRotateShapeState*>(_state.get());

  std::vector<Shape*> selectedShapes = ShapeRegistry::getInstance().getSelectedShapes();

  RealSpaceMatrix rotation;
  rotation.setRotation(state->params.angle_x.get() * M_PI/180., state->params.angle_y.get() * M_PI/180., state->params.angle_z.get() * M_PI/180.);
  Vector translation = state->params.center.get() - (rotation * state->params.center.get());

  for (unsigned int i=0;i<selectedShapes.size();i++){
    Shape s = translate(transform(*selectedShapes[i], rotation), translation);
    std::string name = selectedShapes[i]->getName();
    s.setName(name);
    ShapeRegistry::getInstance().removeShape(name);
    ShapeRegistry::getInstance().addShape(s);
    ShapeRegistry::getInstance().selectShape(name);
  }

  return Action::state_ptr(_state);
}

bool ShapeRotateShapeAction::canUndo() {
  return true;
}

bool ShapeRotateShapeAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
