/*
 * gslmatrix.hpp
 *
 *  Created on: Jan 8, 2010
 *      Author: heber
 */

#ifndef GSLMATRIX_HPP_
#define GSLMATRIX_HPP_

/*********************************************** includes ***********************************/

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iosfwd>

#include <gsl/gsl_matrix.h>


/****************************************** forward declarations *****************************/

class GSLMatrix;

/********************************************** declarations *******************************/

class GSLMatrix {
  friend class LinearSystemOfEquations;
  friend std::ostream &operator<<(std::ostream &ost,const GSLMatrix &mat);

public:
  GSLMatrix(size_t m, size_t n);
  GSLMatrix(const GSLMatrix * const src);
  GSLMatrix(size_t m, size_t n, gsl_matrix *&src);
  ~GSLMatrix();

  // Accessing
  void SetFromDoubleArray(double * x);
  double Get(size_t m, size_t n) const;
  void Set(size_t m, size_t n, double x);
  double *Pointer(size_t m, size_t n);
  const double *const_Pointer(size_t m, size_t n) const;
  size_t getRowCount() const;
  size_t getColumnCount() const;

  // Initializing
  void SetAll(double x);
  void SetZero();
  void SetIdentity();

  // Exchanging elements
  bool SwapRows(size_t i, size_t j);
  bool SwapColumns(size_t i, size_t j);
  bool SwapRowColumn(size_t i, size_t j);

  // Properties
  bool Transpose();
  bool IsNull() const;
  bool IsPositive() const;
  bool IsNegative() const;
  bool IsNonNegative() const;
  bool IsPositiveDefinite() const;
  double Determinant() const;

  // Operators
  GSLMatrix &operator=(const GSLMatrix &src);
  const GSLMatrix &operator+=(const GSLMatrix &rhs);
  const GSLMatrix &operator-=(const GSLMatrix &rhs);
  const GSLMatrix &operator*=(const GSLMatrix &rhs);
  const GSLMatrix operator+(const GSLMatrix &rhs) const;
  const GSLMatrix operator-(const GSLMatrix &rhs) const;
  const GSLMatrix operator*(const GSLMatrix &rhs) const;

private:
  gsl_matrix *matrix;

  size_t rows;
  size_t columns;
};

std::ostream &operator<<(std::ostream &ost,const GSLMatrix &mat);

#endif /* GSLMATRIX_HPP_ */
