/*
 * Parameter.hpp
 *
 *  Created on: Sep 30, 2011
 *      Author: heber
 */

#ifndef PARAMETER_HPP_
#define PARAMETER_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>

#include "CodePatterns/Clone.hpp"

#include "Parser/Parameters/ValueInterface.hpp"


/** This interface represents a clonable, named Value.
 *
 */
class Parameter : virtual public ValueInterface, public Clone<Parameter>
{
public:
  Parameter(const std::string &_name) : name(_name) {}
  virtual ~Parameter() {}

  const std::string &getName() const { return name; }

  virtual Parameter* clone() const=0;

private:
  Parameter();

private:
  const std::string name;
};


#endif /* PARAMETER_HPP_ */
