/*
 * ContinuousParameter_impl.hpp
 *
 *  Created on: Sep 30, 2011
 *      Author: heber
 */

#ifndef CONTINUOUSPARAMETER_IMPL_HPP_
#define CONTINUOUSPARAMETER_IMPL_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "ContinuousParameter.hpp"

/** Constructor for class ContinuousParameter.
 *
 */
template<typename T>
ContinuousParameter<T>::ContinuousParameter(const std::string &_name) :
  Parameter(_name)
{};

/** Constructor for class ContinuousParameter.
 *
 * @param _name name of this parameter
 * @param _ValidRange valid range for this ContinuousValue
 */
template<typename T>
ContinuousParameter<T>::ContinuousParameter(const std::string &_name, const range<T> &_ValidRange) :
  Parameter(_name),
  ContinuousValue<T>(_ValidRange)
{};

/** Destructor for class ContinuousParameter.
 *
 */
template<typename T>
ContinuousParameter<T>::~ContinuousParameter()
{};

/** Creates a clone of this Parameter instance.
 *
 * @return cloned instance
 */
template<typename T>
Parameter* ContinuousParameter<T>::clone() const
{
  ContinuousParameter<T> *instance = new ContinuousParameter<T>(Parameter::getName(), ContinuousValue<T>::getValidRange());
  instance->setValue(ContinuousValue<T>::getValue());
  return instance;
}


#endif /* CONTINUOUSPARAMETER_IMPL_HPP_ */
