/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2013 Frederik Heber. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * MolecularDynamicsAction.cpp
 *
 *  Created on: Jun 14, 2013
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "CodePatterns/Chronos.hpp"

#include "Actions/FragmentationAction/AnalyseFragmentationResultsAction.hpp"
#include "Actions/FragmentationAction/FragmentationAutomationAction.hpp"
#include "Actions/FragmentationAction/MolecularDynamicsAction.hpp"
#include "Actions/MoleculeAction/VerletIntegrationAction.hpp"
#include "Actions/ActionRegistry.hpp"
#include "Actions/ActionSequence.hpp"

#include "Descriptors/AtomDescriptor.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "MolecularDynamicsAction.def"
#include "MakroAction_impl_pre.hpp"
/** =========== define the function ====================== */

// static instances
ActionSequence FragmentationMolecularDynamicsAction::actions;
bool FragmentationMolecularDynamicsAction::isPrepared = false;

void FragmentationMolecularDynamicsAction::prepare(ActionRegistry &AR)
{
  isPrepared = false;
}

void FragmentationMolecularDynamicsAction::unprepare(ActionRegistry &AR)
{
  // empty sequence
  while (actions.removeLastAction() != NULL);
  isPrepared = false;
}

Action::state_ptr FragmentationMolecularDynamicsAction::performCall(){
  // now we can truely prepare
  ActionRegistry &AR = ActionRegistry::getInstance();
  // perform a verlet-integration first, if there are already forces or velocities
  // present. If not, we still copy the position cleanly into a new step where then
  // forces are set according to summed fragmentary contributions. This is much cleaner.
  actions.addAction(AR.getActionByName(std::string("verlet-integration")));
  if (params.DoOutput.get())
    actions.addAction(AR.getActionByName(std::string("output")));
  actions.addAction(AR.getActionByName(std::string("fragment-molecule")));
  actions.addAction(AR.getActionByName(std::string("fragment-automation")));
  actions.addAction(AR.getActionByName(std::string("analyse-fragment-results")));
  setLoop(params.steps.get());
  isPrepared = true;

  Action::state_ptr state(MakroAction::performCall());

  return state;
}

Action::state_ptr FragmentationMolecularDynamicsAction::performUndo(Action::state_ptr _state) {
  Action::state_ptr state(MakroAction::performUndo(_state));

  return state;
}

Action::state_ptr FragmentationMolecularDynamicsAction::performRedo(Action::state_ptr _state){
  Action::state_ptr state(MakroAction::performRedo(_state));

  return state;
}

bool FragmentationMolecularDynamicsAction::canUndo(){
  return true;
}

bool FragmentationMolecularDynamicsAction::shouldUndo(){
  return true;
}
