/*
 * MoleculeView.hpp
 *
 *  Created on: Mar 4, 2010
 *      Author: crueger
 */

#ifndef QTINFOBOX_HPP_
#define QTINFOBOX_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <string>
#include <QtGui/QTabWidget>
#include <QtGui/QTreeWidget>
#include <QTimer>

#include "UIElements/Qt4/InstanceBoard/QtObservedAtom.hpp"
#include "UIElements/Qt4/InstanceBoard/QtObservedMolecule.hpp"

#include "types.hpp"

class periodentafel;

// Forwarding of the Tab-Pages
class QtAtomInfoPage;
class QtMoleculeInfoPage;

class QtObservedInstanceBoard;

class QtInfoBox : public QTabWidget
{
  Q_OBJECT
public:
  QtInfoBox(QtObservedInstanceBoard *_board);
  virtual ~QtInfoBox();

  void showAtom(const atomId_t _id);
  void showMolecule(const moleculeId_t _id);

public slots:
  void atomHover(const atomId_t _id);
  void moleculeHover(const moleculeId_t _id);
  void timerTimeout();

  void clearTabs();

private:
  atomId_t curAtomId;
  atomId_t nextAtomId;
  moleculeId_t curMoleculeId;
  moleculeId_t nextMoleculeId;
  QtMoleculeInfoPage *page_mol;
  QtAtomInfoPage *page_atom;

  QTimer *timer;

  QtObservedInstanceBoard *board;

  int currentPage;

  periodentafel *periode;
};

/**
 * Widget to display the tab page for a single atom
 */
class QtAtomInfoPage : public QTreeWidget
{
  Q_OBJECT
public:
  QtAtomInfoPage(QtObservedAtom::ptr &_atom, periodentafel *_periode, QWidget *parent);
  virtual ~QtAtomInfoPage();

private slots:
  void updatePage();

private:
  QtObservedAtom::ptr atomRef;
  periodentafel *periode;
  QTreeWidget *info;
};

/**
 * Widget to display the tab page for a single molecule
 */
class QtMoleculeInfoPage : public QTreeWidget
{
  Q_OBJECT
public:
  QtMoleculeInfoPage(QtObservedMolecule::ptr &_mol, QWidget *parent);
  virtual ~QtMoleculeInfoPage();

private slots:
  void updatePage();

private:
  QtObservedMolecule::ptr mol;
  QTreeWidget *info;
};
#endif /* QTINFOBOX_HPP_ */
