/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * CopyAction.cpp
 *
 *  Created on: May 10, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "LinearAlgebra/Vector.hpp"
#include "atom.hpp"
#include "Bond/bond.hpp"
#include "molecule.hpp"
#include "World.hpp"

#include <iostream>
#include <fstream>
#include <string>

#include "Actions/MoleculeAction/CopyAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "CopyAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr MoleculeCopyAction::performCall() {
  molecule *copy = NULL;

  // obtain information
  getParametersfromValueStorage();

  copy = params.mol->CopyMolecule();
  Vector *Center = params.mol->DetermineCenterOfAll();
  *Center *= -1.;
  *Center += params.position;
  copy->Translate(Center);
  delete(Center);

  return Action::state_ptr(new MoleculeCopyState(copy,params));
}

Action::state_ptr MoleculeCopyAction::performUndo(Action::state_ptr _state) {
  MoleculeCopyState *state = assert_cast<MoleculeCopyState*>(_state.get());

  state->copy->removeAtomsinMolecule();
  World::getInstance().destroyMolecule(state->copy);

  return Action::state_ptr(_state);
}

Action::state_ptr MoleculeCopyAction::performRedo(Action::state_ptr _state){
  MoleculeCopyState *state = assert_cast<MoleculeCopyState*>(_state.get());

  molecule *copy = state->params.mol->CopyMolecule();
  Vector *Center = state->params.mol->DetermineCenterOfAll();
  *Center *= -1.;
  *Center += state->params.position;
  copy->Translate(Center);
  delete(Center);

  return Action::state_ptr(new MoleculeCopyState(copy,state->params));
}

bool MoleculeCopyAction::canUndo() {
  return true;
}

bool MoleculeCopyAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
