/*
 * MatrixUnittest.hpp
 *
 *  Created on: Jul 7, 2010
 *      Author: crueger
 */

#ifndef MATRIXUNITTEST_HPP_
#define MATRIXUNITTEST_HPP_

#include <cppunit/extensions/HelperMacros.h>

class Matrix;

class MatrixUnittest : public CppUnit::TestFixture
{
  CPPUNIT_TEST_SUITE( MatrixUnittest) ;
  CPPUNIT_TEST ( AccessTest );
  CPPUNIT_TEST ( VectorTest );
  CPPUNIT_TEST ( OperationTest );
  CPPUNIT_TEST ( TransposeTest );
  CPPUNIT_TEST ( RotationTest );
  CPPUNIT_TEST ( InvertTest );
  CPPUNIT_TEST ( DeterminantTest );
  CPPUNIT_TEST ( VecMultTest );
  CPPUNIT_TEST_SUITE_END();

public:
  void setUp();
  void tearDown();

  void AccessTest();
  void VectorTest();
  void OperationTest();
  void TransposeTest();
  void RotationTest();
  void InvertTest();
  void DeterminantTest();
  void VecMultTest();

  Matrix *zero;
  Matrix *one;
  Matrix *full;
  Matrix *diagonal;
  Matrix *perm1;
  Matrix *perm2;
  Matrix *perm3;
  Matrix *perm4;
  Matrix *perm5;
};

#endif /* MATRIXUNITTEST_HPP_ */
