/*
 * NotAllAtomsInsideCuboidAction.hpp
 *
 *  Created on: Aug 9, 2010
 *      Author: heber
 */

#ifndef NOTALLATOMSINSIDECUBOIDACTION_HPP_
#define NOTALLATOMSINSIDECUBOIDACTION_HPP_

#include "Actions/Action.hpp"

class Vector;

void SelectionNotAllAtomsInsideCuboid();

class SelectionNotAllAtomsInsideCuboidAction : public Action {
  friend void SelectionNotAllAtomsInsideCuboid(const Vector &position, const Vector &extension);
  friend void SelectionNotAllAtomsInsideCuboid(const Vector &position, const Vector &extension, const double Xangle, const double Yangle, const double Zangle);

public:
  SelectionNotAllAtomsInsideCuboidAction();
  virtual ~SelectionNotAllAtomsInsideCuboidAction();

  bool canUndo();
  bool shouldUndo();

  virtual const std::string getName();
protected:
  virtual Dialog * fillDialog(Dialog *dialog);
private:
  virtual Action::state_ptr performCall();
  virtual Action::state_ptr performUndo(Action::state_ptr);
  virtual Action::state_ptr performRedo(Action::state_ptr);

  static const char NAME[];
};

#endif /* NOTALLATOMSINSIDECUBOIDACTION_HPP_ */
