/*
 * AllAtomsInsideCuboidAction.hpp
 *
 *  Created on: Aug 9, 2010
 *      Author: heber
 */

#ifndef ALLATOMSINSIDECUBOIDACTION_HPP_
#define ALLATOMSINSIDECUBOIDACTION_HPP_

#include "Actions/Action.hpp"

class Vector;

void SelectionAllAtomsInsideCuboid();

class SelectionAllAtomsInsideCuboidAction : public Action {
  friend void SelectionAllAtomsInsideCuboid(const Vector &position, const Vector &extension);
  friend void SelectionAllAtomsInsideCuboid(const Vector &position, const Vector &extension, const double Xangle, const double Yangle, const double Zangle);

public:
  SelectionAllAtomsInsideCuboidAction();
  virtual ~SelectionAllAtomsInsideCuboidAction();

  bool canUndo();
  bool shouldUndo();

  virtual const std::string getName();
protected:
  virtual Dialog * fillDialog(Dialog *dialog);
private:
  virtual Action::state_ptr performCall();
  virtual Action::state_ptr performUndo(Action::state_ptr);
  virtual Action::state_ptr performRedo(Action::state_ptr);

  static const char NAME[];
};

#endif /* ALLATOMSINSIDECUBOIDACTION_HPP_ */
