/*
 * ion.hpp
 *
 *  Created on: Mar 10, 2014
 *      Author: heber
 */

#ifndef ION_HPP_
#define ION_HPP_

/*********************************************** includes ***********************************/

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iosfwd>
#include <string>

#include "Element/element.hpp"
#include "types.hpp"

#include "boost/serialization/access.hpp"

class periodentafel;

/********************************************** declarations *******************************/

/** Ion of a chemical element.
 *
 * This class extends element with an ionization.
 */
class ion : public element
{
  friend class periodentafel;
public:
  ion(const element& _element, const int _ionization);
  ion(const element* const _element, const int _ionization);
  virtual ~ion();

  ion& operator=(const element &other);
  ion& operator=(const ion &other);

  // accessor functions
  virtual atomicNumber_t getAtomicNumber() const;
  virtual double getCharge() const;
  virtual double getValence() const;
  virtual int getNoValenceOrbitals() const;

  bool operator==(const element &other) const;
  bool operator!=(const element &other) const;
  bool operator==(const ion &other) const;
  bool operator!=(const ion &other) const {
    return !(*this == other);
  }

private:
  friend class boost::serialization::access;
  // private default cstor, just for serialization
  ion();

  // serialization
  template<class Archive>
  void serialize(Archive & ar, const unsigned int version)
  {
    ar & boost::serialization::base_object<element>(*this);
    ar & const_cast<int &>(ionization);
  }

  const int ionization;    //!< missing or surplus electrons of this ion
};

std::ostream &operator<<(std::ostream&,const ion&);

#endif /* ION_HPP_ */
